package com.example.sefinsa_app.utilities;

import static com.example.sefinsa_app.ui.prestamos.PrestamosFragment.updateUIWithPrestamos;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.net.ParseException;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentContainerView;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.JsonRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.AvalController;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.PrestamoController;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Semana;
import com.example.sefinsa_app.ui.clientes.documentos.ClientesDocumentosFragment;
import com.example.sefinsa_app.ui.clientes.fotos.ClientesAvalesFotosFragment;
import com.example.sefinsa_app.ui.prestamos.PrestamosFragment;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.nex3z.flowlayout.FlowLayout;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
public class PrestamosAdapter extends RecyclerView.Adapter<PrestamosAdapter.PrestamosViewHolder> {
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private Uri image_uri;

    Context context;
    ArrayList<Prestamo> prestamos;

    ArrayList<Cliente> clientes;
    ArrayList<String> avales;
    ArrayList<String> nombresAvales;
    public ArrayList<Prestamo> prestamosSeleccionados = new ArrayList<Prestamo>();
    public ArrayList<Prestamo> prestamosPagar = new ArrayList<Prestamo>();
    public ArrayList<Prestamo> prestamosPagarConMulta = new ArrayList<Prestamo>();
    public ArrayList<Prestamo> prestamosNoPagar = new ArrayList<Prestamo>();
    public ArrayList<Prestamo> prestamosAdelantar = new ArrayList<Prestamo>();

    private SharedPreferences sesion;
    //private boolean camaraGarantiasRetiradas = false;
    public boolean isSelectMode = true, seleccionPagar = false, seleccionPagarConMulta = false, seleccionNoPagar = false, seleccionAdelantar = false;
    String fecha_pago;
    String pago_semanal;

    //public ArrayList<String> semanasPagadasList, semanasPagadasConMultaList, semanasNoPagadasList, semanasPendientesList;
    public ArrayList<Semana> semanasGeneradas, semanasPagadasList, semanasPagadasConMultaList, semanasNoPagadasList, semanasPendientesList, semanasAdelantadasList;
    public Button btnCamGarantiasRetiradas, btnGuardarGarantiasRetiradas;
    public FlowLayout contenedorSemanas;
    String path;
    private int banderaGarantiasRetiradas;
    private RecyclerView recyclerViewPagos;
    private ShimmerFrameLayout shimmer;
    private PagosAdapter pagosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private ArrayList<Pago> pagos;
    private ArrayList<Pago> pagos2;
    public ArrayList<String> pathsGarantiasRetiradas;
    public List<MultipartBody.Part> archivosGeneral;
    private PrestamosFragment fragment;
    private ArrayAdapter<Cliente> clientesAdapter;
    private ArrayAdapter<Aval> avalesAdapter;
    private AutoCompleteTextView avalesAutoCompleteTextView;
    private String aval_id = "";
    private int prestamo_id = 0;
    private int previousLengthCliente, previousLengthAval;
    private boolean backSpaceCliente, backSpaceAval;
    private TextInputLayout tlNombreAval;
    private Bundle bundle;
    private AvalController avalController;
    public int idgarantia=0;
    private Button btnToggleVisibility;
    private boolean isVisible = false;
    public int cantidadTotalGarantias = 0;
    private ProgressDialogFragment progressDialogFragment;
    public PrestamosAdapter(Context context, PrestamosFragment fragment, ArrayList<Prestamo> prestamos, ArrayList<MultipartBody.Part> archivosGeneral, ArrayList<String> pathsGarantiasRetiradas, ArrayList<Cliente> clientes, Bundle bundle) {
        this.context = context;
        this.fragment = fragment;
        this.prestamos = prestamos;
        this.archivosGeneral = archivosGeneral;
        this.pathsGarantiasRetiradas = pathsGarantiasRetiradas;
        this.clientes = clientes;
        this.bundle = bundle;
        setHasStableIds(true);
    }
    private List<Prestamo> prestamosList;

    // Constructor y otros métodos del adaptador

    public void updateData(List<Prestamo> newPrestamos) {
        prestamosList.clear();
        prestamosList.addAll(newPrestamos);
        notifyDataSetChanged();
    }
    public void updateData(ArrayList<Prestamo> nuevosPrestamos) {
        this.prestamos.addAll(nuevosPrestamos);
        notifyDataSetChanged();
    }
    // Método para obtener el Bundle
    private Bundle getArguments() {
        return bundle;
    }
    public void ClientesAdapter(Context context, ArrayList<Cliente> clientes) {
        this.context = context;
        this.clientes = clientes;
    }
    public void addFilesAndPaths(ArrayList<MultipartBody.Part> nuevosArchivos, ArrayList<String> nuevasRutas) {
        archivosGeneral.addAll(nuevosArchivos);
        pathsGarantiasRetiradas.addAll(nuevasRutas);
    }
    public void updateButtonText() {
        if (btnCamGarantiasRetiradas != null) {
            btnCamGarantiasRetiradas.setText("Garantías retiradas (" + pathsGarantiasRetiradas.size() + ")");
        }
    }
    public void setListaFiltrada(ArrayList<Prestamo> filteredListPrestamos) {
        this.prestamos = filteredListPrestamos;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public PrestamosViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        sesion = context.getSharedPreferences("sesion", Context.MODE_PRIVATE);
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.prestamo_item_2, parent, false);
        return new PrestamosViewHolder(v);
    }
    @Override
    public void onBindViewHolder(@NonNull PrestamosViewHolder holder, int position) {
        // Verificar que no haya nullPointerException
        if (holder != null) {
            holder.imprimir(position);
        } else {
            Log.e("PrestamosAdapter", "Error al intentar acceder al holder.");
        }
    }


    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return prestamos.size();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void clear() {
        prestamos.clear();
        notifyDataSetChanged();
    }
    /////COMUNICAR MODAL CON FRAGMENT
    // Método para establecer el DialogListener
    ////////////////// FIN //////////////////////////
    public void addAll(ArrayList<Prestamo> list) {
        prestamos = list;
        notifyDataSetChanged();
    }

    public static class CustomDialogFragment extends DialogFragment {

        @Nullable
        @Override
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return inflater.inflate(R.layout.custom_dialog_layout, container, false);
        }

        @Override
        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);

            // Obtener el FragmentContainerView del diálogo inflado
            FragmentContainerView fragmentContainerView = view.findViewById(R.id.nav_host_fragment);

            // Crear el fragmento ClientesDocumentosFragment
            ClientesDocumentosFragment fragment = new ClientesDocumentosFragment();
            Bundle args = getArguments();
            fragment.setArguments(args);

            // Iniciar la transacción del fragmento
            getChildFragmentManager().beginTransaction()
                    .replace(fragmentContainerView.getId(), fragment)
                    .commit();
            Button closeButton = view.findViewById(R.id.close_button);
            closeButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss(); // Cierra la ventana emergente
                }
            });
        }
    }
    public static class CustomDialogFragment2 extends DialogFragment {

        @Nullable
        @Override
        public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
            return inflater.inflate(R.layout.custom_dialog_layout, container, false);
        }

        @Override
        public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
            super.onViewCreated(view, savedInstanceState);

            FragmentContainerView fragmentContainerView = view.findViewById(R.id.nav_host_fragment);

            ClientesAvalesFotosFragment fragment2 = new ClientesAvalesFotosFragment();
            Bundle args2 = getArguments();
            fragment2.setArguments(args2);

            getChildFragmentManager().beginTransaction()
                    .replace(fragmentContainerView.getId(), fragment2)
                    .commit();
            Button closeButton = view.findViewById(R.id.close_button);
            closeButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss(); // Cierra la ventana emergente
                }
            });
        }
    }
    public PrestamosAdapter(Context context) {
        this.context = context;
    }
    public class PrestamosViewHolder extends RecyclerView.ViewHolder {

        TextView tvTarjetonPrestamo, tvClientePrestamo, tvFechaPrestamo, tvMontoPrestamo, tvSemanalPrestamo, tvModalidadPrestamo, tvRutaPoblacionPrestamo, tvCantidadPrestamosSeleccionados, tvSeleccion;

        ConstraintLayout prestamo_item_bg;

        Button btnVerInformacion, btnVerPagos, btnCambiarAval,btnGuardarCambioAval;

        LinearLayoutCompat linearLayout;
        RecyclerView rvPrestamos;
        Button btnPagar, btnPagarConMulta, btnNoPagar, btnCancelar, btnAdelantar;

        String informacion = "";

        public PrestamosViewHolder(@NonNull View itemView) {
            super(itemView);

            tvTarjetonPrestamo = itemView.findViewById(R.id.tarjetonPrestamoLista);
            tvClientePrestamo = itemView.findViewById(R.id.clientePrestamoLista);
            //tvFechaPrestamo = itemView.findViewById(R.id.fechaPrestamo);
            tvMontoPrestamo = itemView.findViewById(R.id.montoPrestamoLista);
            /*tvSemanalPrestamo = itemView.findViewById(R.id.semanalPrestamo);
            tvModalidadPrestamo = itemView.findViewById(R.id.modalidadPrestamo);
            tvRutaPoblacionPrestamo = itemView.findViewById(R.id.rutaPoblacionPrestamo);*/
            btnVerInformacion = itemView.findViewById(R.id.btnVerInfoPrestamo);
            btnVerPagos = itemView.findViewById(R.id.btnVerPagosPrestamo);
            btnCambiarAval = itemView.findViewById(R.id.btnCambiarAval);

            linearLayout = ((Activity) context).findViewById(R.id.botones);
            rvPrestamos = ((Activity) context).findViewById(R.id.rvPrestamos);
            tvCantidadPrestamosSeleccionados = ((Activity) context).findViewById(R.id.tvCantidadPrestamosSeleccionados);
            btnPagar = ((Activity) context).findViewById(R.id.btnPagar);
            btnPagarConMulta = ((Activity) context).findViewById(R.id.btnPagarConMulta);
            btnNoPagar = ((Activity) context).findViewById(R.id.btnNoPagar);
            btnAdelantar = ((Activity) context).findViewById(R.id.btnAdelantarPagoPrestamo);
            btnCancelar = ((Activity) context).findViewById(R.id.btnCancelar);
            tvSeleccion = ((Activity) context).findViewById(R.id.tvSeleccion);

            prestamo_item_bg = itemView.findViewById(R.id.prestamo_item_bg);

            btnCamGarantiasRetiradas = itemView.findViewById(R.id.btnCamGarantiasRetiradas);
            /*
            clientes = new ArrayList<Cliente>();
            if (clientes == null || clientes.size() == 0) {
                getAvales();
            }
            */
        }
        private String formatFecha(String fecha) {
            if (fecha == null) {
                return "...";
            }

            SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat desiredFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            try {
                Date date = originalFormat.parse(fecha);
                return desiredFormat.format(date);
            } catch (ParseException | java.text.ParseException e) {
                e.printStackTrace();
                return "...";
            }
        }

        public void cambio() {
            AlertDialog.Builder confirmDialog = new AlertDialog.Builder(context);
            confirmDialog.setTitle("Confirmación");
            confirmDialog.setMessage("¿Está seguro de cambiar el aval?");
            confirmDialog.setPositiveButton("Sí", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    DatabaseHelper dbHelper = new DatabaseHelper(context);
                    SQLiteDatabase db = dbHelper.getWritableDatabase(); // Obtén una referencia de escritura a la base de datos

                    // Crea un objeto ContentValues para los valores que quieres actualizar
                    ContentValues values = new ContentValues();
                    values.put("aval_id", aval_id); // Aquí 'aval_id' es el nombre de la columna en la tabla que representa el aval
                    Log.d("DEBUG", "ID AVAL para actualizar...............................: " + aval_id);
                    long timestamp = System.currentTimeMillis();
                    // Convertir a objeto Date
                    Date date = new Date(timestamp);
                    // Formatear la fecha a un formato legible
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
                    String formattedDate = sdf.format(date);
                    // Almacenar la fecha formateada como texto
                    values.put("updated_at", formattedDate); // Ahora se almacena como texto

                    // Realiza la actualización en la tabla 'prestamos'
                    int rowsAffected = db.update("prestamos", values, "id = ?", new String[]{String.valueOf(prestamo_id)});
                    if (rowsAffected > 0) {
                        CambiarAval(String.valueOf(prestamo_id), aval_id);
                        Log.d("DEBUG", "Aval actualizado exitosamente en el préstamo con ID: " + prestamo_id);
                        Toast.makeText(context, "Aval actualizado", Toast.LENGTH_LONG).show();
                    } else {
                        Log.d("DEBUG", "No se pudo actualizar el aval en el préstamo con ID: " + prestamo_id);
                    }

                    db.close(); // Cierra la conexión a la base de datos
                    cargarPrestamosConsulta();
                    //PrestamosWorker.enqueueWork(context);

                }
            });
            confirmDialog.setNegativeButton("No", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss(); // Cierra el diálogo de confirmación
                }
            });
            confirmDialog.show(); // Muestra el diálogo de confirmación
        }

        @SuppressLint("StaticFieldLeak")
        public void imprimir(int position) {
            String nombre_aval = prestamos.get(position).getNombre_aval();

            tvTarjetonPrestamo.setText(prestamos.get(position).getNumero_tarjeton());
            tvClientePrestamo.setText(Html.fromHtml(
                    prestamos.get(position).getNombre_completo() + "<br/>" +
                            "AVAL: " + nombre_aval + "<br/>" +
                            "GRUPO: " + prestamos.get(position).getGrupo_poblacion()
            ));
            //tvClientePrestamo.setText(prestamos.get(position).getNombre_completo());
            tvMontoPrestamo.setText("$" + prestamos.get(position).getMonto_prestado());
            //tvFechaPrestamo.setText(prestamos.get(position).getFecha_prestamo());
            /*tvSemanalPrestamo.setText("$" +prestamos.get(position).getPago_semanal());
            tvModalidadPrestamo.setText(prestamos.get(position).getSemanas() + " semanas");
            tvRutaPoblacionPrestamo.setText(prestamos.get(position).getNombre_ruta() + " " + prestamos.get(position).getNombre_poblacion());
             */
            informacion = "<p> <b>Cliente:</b> " + prestamos.get(position).getNombre_completo() + " <br><br> " + "<b>Dirección:</b> "
                    + prestamos.get(position).getDireccion_cliente() + " <br><br> " + "<b>Teléfono:</b> " + prestamos.get(position).getTelefono_cliente()
                    + " <br><br> " + "<b>Garantías:</b> " + prestamos.get(position).getGarantias() + " <p> <br> " +
                    "<p> <b>Aval:</b> " + prestamos.get(position).getNombre_aval() + " <br><br> "
                    + "<b>Dirección:</b> " + prestamos.get(position).getDireccion_aval() + " <br><br> " + "<b>Teléfono:</b> " +
                    prestamos.get(position).getTelefono_aval() + " <br><br> "
                    + "<b>Otras referencías:</b> " + prestamos.get(position).getOr_aval() + " <br><br> " + "<b>Garantías:</b> " +
                    prestamos.get(position).getGarantias_aval() + "</p>";

            /*if (prestamos.get(position).getStatus().equals("0")) {
                prestamo_item_bg.setBackgroundColor(context.getResources().getColor(R.color.light));
            } else if (prestamos.get(position).getStatus().equals("1")) {
                prestamo_item_bg.setBackgroundColor(context.getResources().getColor(R.color.success_light));
            } else if (prestamos.get(position).getStatus().equals("2")) {
                prestamo_item_bg.setBackgroundColor(context.getResources().getColor(R.color.primary_light));
            } else if (prestamos.get(position).getStatus().equals("-1")) {
                prestamo_item_bg.setBackgroundColor(context.getResources().getColor(R.color.danger_light));
            }*/


            prestamo_item_bg.setOnLongClickListener(new View.OnLongClickListener() {
                @Override
                public boolean onLongClick(View view) {
                    if (seleccionPagar) {

                        if (prestamos.get(position).isSelectedPagar()) {
                            prestamos.get(position).setSelectedPagar(false);
                            if (!prestamos.get(position).getEs_semana_14().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")
                                    || !prestamos.get(position).getEs_semana_19().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")) {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.black));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            } else {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.light));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            }
                            prestamosPagar.remove(prestamos.get(position));
                        } else {

                            prestamos.get(position).setSelectedPagar(true);
                            prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.success_custom));
                            tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));

                            prestamosPagar.add(prestamos.get(position));

                            if (prestamosNoPagar.contains(prestamos.get(position))) {
                                prestamosNoPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedNoPagar(false);
                            }
                            if (prestamosPagarConMulta.contains(prestamos.get(position))) {
                                prestamosPagarConMulta.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagarConMulta(false);
                            }

                            if (prestamosAdelantar.contains(prestamos.get(position))) {
                                prestamosAdelantar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }

                    } else if (seleccionPagarConMulta) {
                        if (prestamos.get(position).isSelectedPagarConMulta()) {
                            prestamos.get(position).setSelectedPagarConMulta(false);
                            if (!prestamos.get(position).getEs_semana_14().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")
                                    || !prestamos.get(position).getEs_semana_19().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")) {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.black));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            } else {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.light));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            }
                            prestamosPagarConMulta.remove(prestamos.get(position));

                        } else {
                            prestamos.get(position).setSelectedPagarConMulta(true);
                            prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.warning_custom));
                            tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));

                            prestamosPagarConMulta.add(prestamos.get(position));

                            if (prestamosPagar.contains(prestamos.get(position))) {
                                prestamosPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagar(false);
                            }
                            if (prestamosNoPagar.contains(prestamos.get(position))) {
                                prestamosNoPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedNoPagar(false);
                            }

                            if (prestamosAdelantar.contains(prestamos.get(position))) {
                                prestamosAdelantar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }
                    } else if (seleccionNoPagar) {
                        if (prestamos.get(position).isSelectedNoPagar()) {
                            prestamos.get(position).setSelectedNoPagar(false);
                            if (!prestamos.get(position).getEs_semana_14().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")
                                    || !prestamos.get(position).getEs_semana_19().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")) {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.black));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            } else {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.light));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            }
                            prestamosNoPagar.remove(prestamos.get(position));
                        } else {
                            prestamos.get(position).setSelectedNoPagar(true);
                            prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.danger_custom));
                            tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            prestamosNoPagar.add(prestamos.get(position));

                            if (prestamosPagar.contains(prestamos.get(position))) {
                                prestamosPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagar(false);
                            }
                            if (prestamosPagarConMulta.contains(prestamos.get(position))) {
                                prestamosPagarConMulta.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagarConMulta(false);

                            }

                            if (prestamosAdelantar.contains(prestamos.get(position))) {
                                prestamosAdelantar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedAdelantar(false);
                            }
                        }
                    } else if (seleccionAdelantar) {
                        if (prestamos.get(position).isSelectedAdelantar()) {
                            prestamos.get(position).setSelectedAdelantar(false);
                            if (!prestamos.get(position).getEs_semana_14().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")
                                    || !prestamos.get(position).getEs_semana_19().equals("0") &&
                                    prestamos.get(position).getTiene_pendientes().equals("0") &&
                                    prestamos.get(position).getTiene_multas().equals("0") &&
                                    prestamos.get(position).getTiene_folios().equals("0")) {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.black));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            } else {
                                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.light));
                                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                            }
                            prestamosAdelantar.remove(prestamos.get(position));
                        } else {
                            prestamos.get(position).setSelectedAdelantar(true);
                            prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.secondary));
                            tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                            prestamosAdelantar.add(prestamos.get(position));

                            if (prestamosPagar.contains(prestamos.get(position))) {
                                prestamosPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagar(false);
                            }
                            if (prestamosPagarConMulta.contains(prestamos.get(position))) {
                                prestamosPagarConMulta.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedPagarConMulta(false);

                            }
                            if (prestamosNoPagar.contains(prestamos.get(position))) {
                                prestamosNoPagar.remove(prestamos.get(position));
                                prestamos.get(position).setSelectedNoPagar(false);
                            }
                        }
                    }

                    if (prestamosPagar.size() != 0) {
                        btnPagar.setText(" (" + prestamosPagar.size() + ")");
                    } else {
                        btnPagar.setText("");
                    }

                    if (prestamosAdelantar.size() != 0) {
                        btnAdelantar.setText(" (" + prestamosAdelantar.size() + ")");
                    } else {
                        btnAdelantar.setText("");
                    }

                    if (prestamosPagarConMulta.size() != 0) {
                        btnPagarConMulta.setText("M (" + prestamosPagarConMulta.size() + ")");
                    } else {
                        btnPagarConMulta.setText("M");
                    }

                    if (prestamosNoPagar.size() != 0) {
                        btnNoPagar.setText(" (" + prestamosNoPagar.size() + ")");
                    } else {
                        btnNoPagar.setText("");
                    }

                    btnCancelar.setText("Cancelar (" + (prestamosPagar.size() + prestamosPagarConMulta.size() + prestamosNoPagar.size()) + ")");

                    return false;

                }
            });

            btnPagar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    seleccionPagar = true;
                    seleccionAdelantar = false;
                    seleccionPagarConMulta = false;
                    seleccionNoPagar = false;
                    tvSeleccion.setText("Selección: Pagar");
                }
            });

            btnAdelantar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    seleccionAdelantar = true;
                    seleccionPagar = false;
                    seleccionPagarConMulta = false;
                    seleccionNoPagar = false;
                    tvSeleccion.setText("Selección: Adelantar Pago");
                }
            });

            btnPagarConMulta.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    seleccionPagar = false;
                    seleccionAdelantar = false;
                    seleccionPagarConMulta = true;
                    seleccionNoPagar = false;
                    tvSeleccion.setText("Selección: Pagar con multa");
                }
            });
            btnNoPagar.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    seleccionPagar = false;
                    seleccionAdelantar = false;
                    seleccionPagarConMulta = false;
                    seleccionNoPagar = true;
                    tvSeleccion.setText("Selección: No pagar");
                }
            });

            if (prestamos.get(position).isSelectedPagar()) {
                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.success_custom));
                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
            } else if (prestamos.get(position).isSelectedPagarConMulta()) {
                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.warning_custom));
                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
            } else if (prestamos.get(position).isSelectedNoPagar()) {
                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.danger_custom));
                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
            } else if (prestamos.get(position).isSelectedAdelantar()) {
                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.secondary));
                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
            } else {
                String esSemana14 = prestamos.get(position).getEs_semana_14();
                String tienePendientes = prestamos.get(position).getTiene_pendientes();
                String tieneMultas = prestamos.get(position).getTiene_multas();
                String tieneFolios = prestamos.get(position).getTiene_folios();

                if ((esSemana14 != null && !esSemana14.equals("0") &&
                        tienePendientes != null && tienePendientes.equals("0") &&
                        tieneMultas != null && tieneMultas.equals("0") &&
                        tieneFolios != null && tieneFolios.equals("0")) ||
                        (prestamos.get(position).getEs_semana_19() != null && !prestamos.get(position).getEs_semana_19().equals("0") &&
                                tienePendientes != null && tienePendientes.equals("0") &&
                                tieneMultas != null && tieneMultas.equals("0") &&
                                tieneFolios != null && tieneFolios.equals("0"))) {
                    prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.black));
                    tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                    tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                    tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                } else {
                    prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.light));
                    tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                    tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                    tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.black));
                }
            }

            btnCambiarAval.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    // Mostrar el ProgressDialog
                    ProgressDialog progressDialog = new ProgressDialog(context);
                    progressDialog.setMessage("Cargando avales, por favor espere...");
                    progressDialog.setCancelable(false);
                    progressDialog.show();
                    prestamo_id= Integer.parseInt(prestamos.get(position).getId());
                    Log.d("DEBUG", "ID PRESTAMO para actualizar...............................: " + prestamo_id);
                    // Inflar el diseño del diálogo
                    View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_cambio_aval, null);

                    tlNombreAval = dialogView.findViewById(R.id.tlNombreAval);
                    avalesAutoCompleteTextView = dialogView.findViewById(R.id.acNombreAval);

                    // Asegúrate de que las listas estén inicializadas
                    if (avales == null) {
                        avales = new ArrayList<>(); // Lista para IDs
                    }
                    if (nombresAvales == null) {
                        nombresAvales = new ArrayList<>(); // Lista para nombres
                    }

                    // Verificar si las listas están vacías
                    if (avales.isEmpty() || nombresAvales.isEmpty()) {
                        getAvales(progressDialog, dialogView);
                    } else {
                        // Si ya se cargaron los avales, mostrar el diálogo de cambio de aval
                        showChangeAvalDialog(progressDialog, dialogView);
                        progressDialog.dismiss();
                    }
                }

                private void getAvales(ProgressDialog progressDialog, View dialogView) {
                    DatabaseHelper dbHelper = new DatabaseHelper(context);
                    SQLiteDatabase db = dbHelper.getReadableDatabase(); // Abre la base de datos en modo lectura
                    Cursor cursor = null;

                    try {
                        // Consulta para obtener todos los avales
                        cursor = db.rawQuery("SELECT id, nombre_completo FROM avales", null);

                        avales.clear(); // Limpiar lista en caso de recarga
                        nombresAvales.clear(); // Limpiar lista de nombres también

                        if (cursor != null && cursor.moveToFirst()) {
                            do {
                                String id = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                                String nombreCompleto = cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo"));

                                // Agregar el ID y el nombre a sus respectivas listas
                                avales.add(id);
                                nombresAvales.add(nombreCompleto); // Lista para el AutoCompleteTextView

                            } while (cursor.moveToNext());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                        Toast.makeText(context, "Error al obtener los avales", Toast.LENGTH_SHORT).show();
                    } finally {
                        if (cursor != null) {
                            cursor.close(); // Cierra el cursor para liberar recursos
                        }
                        db.close(); // Cierra la base de datos
                    }

                    // Ocultar el ProgressDialog
                    progressDialog.dismiss();

                    // Muestra el diálogo de cambio de aval
                    showChangeAvalDialog(progressDialog, dialogView);
                }


                private void showChangeAvalDialog(ProgressDialog progressDialog, View dialogView) {
                    ArrayAdapter<String> avalesAdapter = new ArrayAdapter<>(context, android.R.layout.simple_dropdown_item_1line, nombresAvales);
                    avalesAutoCompleteTextView.setThreshold(1);
                    avalesAutoCompleteTextView.setAdapter(avalesAdapter);

                    AlertDialog.Builder builder = new AlertDialog.Builder(context);
                    builder.setView(dialogView);
                    AlertDialog dialog = builder.create();

                    Button btnCambiarAvalDialog = dialogView.findViewById(R.id.btnGuardarCambioAval);
                    btnCambiarAvalDialog.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            // Crear el diálogo de confirmación
                            if (!tlNombreAval.getEditText().getText().toString().isEmpty() || tlNombreAval.getEditText().getText() != null) {
                                AvalController ac = new AvalController(context);
                                String avalId = ac.getAvalByNombre(tlNombreAval.getEditText().getText().toString().toUpperCase());
                                if (!avalId.isEmpty() || avalId != null) {
                                    ClienteController cc = new ClienteController(context);
                                    String prestaNombre = cc.getPrestaNombreFromAvalEnCliente(tlNombreAval.getEditText().getText().toString().toUpperCase());
                                    if (Objects.equals(prestaNombre, "1")) {
                                        AlertDialog.Builder b = new AlertDialog.Builder(context);
                                        b.setTitle("Aviso");
                                        b.setMessage("¡Este cliente esta marcado como PrestaNombre!, llame a su administrador para pedir el desbloqueo del cliente");
                                        b.setPositiveButton("Aceptar", null);

                                        AlertDialog dialog = b.create();
                                        dialog.show();
                                    } else {
                                        cambio();
                                    }
                                } else {
                                    cambio();
                                }
                            } else {
                                cambio();
                            }
                            dialog.dismiss();
                        }
                    });

                    avalesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                        @Override
                        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                            // Al seleccionar un nombre, se obtiene el ID correspondiente
                            aval_id = avales.get(i); // Aquí obtienes el ID del aval seleccionado
                            Log.d("DEBUG", "El aval_id es: " + aval_id);
                        }
                    });

                    dialog.show();
                }


                private Bundle getArguments() {
                    return bundle;
                }
            });

            btnVerInformacion.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {

                    final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_info_cliente, null, false);
                    TextView tvSemanasPendientes = dialogView.findViewById(R.id.tvSemanasPendientes);
                    TextView tvSemanasAtraso = dialogView.findViewById(R.id.tvSemanasAtraso);

                    pagos2 = new ArrayList<Pago>();
                    pagosAdapter = new PagosAdapter(context, pagos2, prestamos.get(position));
                    getInfo(prestamos.get(position).getId(), position, tvSemanasPendientes, tvSemanasAtraso);
                    TextView tvNombreCliente = dialogView.findViewById(R.id.tvNombreCliente);
                    TextView tvDireccionCliente = dialogView.findViewById(R.id.tvDireccionCliente);
                    TextView tvTelefonoCliente = dialogView.findViewById(R.id.tvTelefonoCliente);
                    TextView tvUbicacionCliente = dialogView.findViewById(R.id.tvUbicacionCliente);
                    TextView tvMapaCliente = dialogView.findViewById(R.id.tvMapaCliente);

                    TextView tvColocadoraCliente = dialogView.findViewById(R.id.tvColocadoraCliente);
                    LinearLayoutCompat llColocadoraCliente = dialogView.findViewById(R.id.llColocadoraCliente);
                    //llColocadoraCliente.setVisibility(View.GONE);
                    TextView tvPoblacionCliente = dialogView.findViewById(R.id.tvPoblacionCliente);
                    LinearLayoutCompat llPoblacionCliente = dialogView.findViewById(R.id.llPoblacionCliente);
                    //llPoblacionCliente.setVisibility(View.GONE);
                    TextView tvGarantiasCliente = dialogView.findViewById(R.id.tvGarantiasCliente);
                    TextView tvMapaAval = dialogView.findViewById(R.id.tvMapaAval);

                    TextView tvNombreAval = dialogView.findViewById(R.id.tvNombreAval);
                    TextView tvDireccionAval = dialogView.findViewById(R.id.tvDireccionAval);
                    TextView tvTelefonoAval = dialogView.findViewById(R.id.tvTelefonoAval);
                    TextView tvORAval = dialogView.findViewById(R.id.tvORAval);
                    TextView tvGarantiasAval = dialogView.findViewById(R.id.tvGarantiasAval);

                    TextView tvUpdGarantiasCliente = dialogView.findViewById(R.id.tvUpdGarantiasCliente);
                    TextView tvUpdComprobantesCliente = dialogView.findViewById(R.id.tvUpdComprobantesCliente);
                    TextView tvUpdGarantiasAval = dialogView.findViewById(R.id.tvUpdGarantiasAval);
                    TextView tvUpdComprobantesAval = dialogView.findViewById(R.id.tvUpdComprobantesAval);

                    String updateGarantiasCliente = prestamos.get(position).getUpdate_garantias_cliente();
                    String updateComprobantesCliente = prestamos.get(position).getUpdate_comprobantes_cliente();
                    updateGarantiasCliente = updateGarantiasCliente != null ? updateGarantiasCliente : "...";
                    updateComprobantesCliente = updateComprobantesCliente != null ? updateComprobantesCliente : "...";

                    String updateGarantiasAval = prestamos.get(position).getUpdate_garantias_aval();
                    String updateComprobantesAval = prestamos.get(position).getUpdate_comprobantes_aval();
                    updateComprobantesAval = updateComprobantesAval != null ? updateComprobantesAval : "...";
                    updateGarantiasAval = updateGarantiasAval != null ? updateGarantiasAval : "...";

                    updateGarantiasCliente = formatFecha(updateGarantiasCliente);
                    updateComprobantesCliente = formatFecha(updateComprobantesCliente);
                    updateGarantiasAval = formatFecha(updateGarantiasAval);
                    updateComprobantesAval = formatFecha(updateComprobantesAval);

                    tvUpdGarantiasCliente.setText(Html.fromHtml("<b>Últimas fotos Garantías:</b><br>" + updateGarantiasCliente));
                    tvUpdComprobantesCliente.setText(Html.fromHtml("<b>Últimas fotos Comprobantes:</b><br>" + updateComprobantesCliente));

                    tvUpdGarantiasAval.setText(Html.fromHtml("<b>Últimas fotos Garantías:</b><br>" + updateGarantiasAval));
                    tvUpdComprobantesAval.setText(Html.fromHtml("<b>Últimas fotos Comprobantes:</b><br>" + updateComprobantesAval));



                    tvColocadoraCliente.setText(Html.fromHtml("<b>Colocadora:</b> " + prestamos.get(position).getNombre_colocadora()));
                    tvNombreCliente.setText(Html.fromHtml("<b>Cliente:</b> " + prestamos.get(position).getNombre_completo()));
                    tvPoblacionCliente.setText(Html.fromHtml("<b>Población:</b> " + prestamos.get(position).getNombre_poblacion()));
                    tvDireccionCliente.setText(Html.fromHtml("<b>Dirección:</b> " + prestamos.get(position).getDireccion_cliente()));
                    tvTelefonoCliente.setText(Html.fromHtml("<b>Teléfono:</b> " + prestamos.get(position).getTelefono_cliente()));
                    tvGarantiasCliente.setText(Html.fromHtml("<b>Garantías:</b> " + prestamos.get(position).getGarantias()));
                    tvMapaCliente.setText(Html.fromHtml("<b>Ver ubicación</b>"));
                    tvMapaAval.setText(Html.fromHtml("<b>Ver ubicación</b>"));

                    tvNombreAval.setText(Html.fromHtml("<b>Aval:</b> " + prestamos.get(position).getNombre_aval()));
                    tvDireccionAval.setText(Html.fromHtml("<b>Dirección:</b> " + prestamos.get(position).getDireccion_aval()));
                    tvTelefonoAval.setText(Html.fromHtml("<b>Teléfono:</b> " + prestamos.get(position).getTelefono_aval()));
                    tvORAval.setText(Html.fromHtml("<b>Otras referencías:</b> " + prestamos.get(position).getOr_aval()));
                    tvGarantiasAval.setText(Html.fromHtml("<b>Garantías:</b> " + prestamos.get(position).getGarantias_aval()));

                    if (prestamos.get(position).getLatitud() != null && prestamos.get(position).getLongitud() != null) {
                        tvUbicacionCliente.setText(Html.fromHtml("<b>Ver ubicación"));
                    } else {
                        tvUbicacionCliente.setVisibility(View.GONE);

                    }

                    VolleyS vs = VolleyS.getInstance(context);
                    RequestQueue requestQueue = vs.getRequestQueue();

                    JSONObject data = new JSONObject();
                    try {
                        data.put("func", "getCords");
                        data.put("id", prestamos.get(position).getCliente_id());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    Log.d("15", "loadAllData: ");

                    JsonObjectRequest req = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                            new Response.Listener<JSONObject>() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    try {
                                        if (!response.get("data").toString().equals("false")) {
                                            JSONObject jsonObject = (JSONObject) response.get("data");

                                            String latitud = jsonObject.getString("latitud");
                                            String longitud = jsonObject.getString("longitud");

                                            if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                                tvMapaCliente.setText("");
                                            } else {
                                                tvMapaCliente.setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View v) {
                                                        Intent intent = new Intent(android.content.Intent.ACTION_VIEW);
                                                        intent.setData(Uri.parse("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                        intent.setPackage("com.google.android.apps.maps");
                                                        context.startActivity(intent);
                                                    }
                                                });
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            },
                            new Response.ErrorListener() {
                                @Override public void onErrorResponse(VolleyError error) { }
                            });

                    requestQueue.add(req);

                    JSONObject data2 = new JSONObject();
                    try {
                        data2.put("func", "coordenadasAval");
                        data2.put("aval_id", prestamos.get(position).getAval_id());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                    Log.d("16", "loadAllData: ");

                    JsonObjectRequest req2 = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data2,
                            new Response.Listener<JSONObject>() {
                                @Override
                                public void onResponse(JSONObject response) {
                                    try {
                                        if (!response.get("data").toString().equals("false")) {
                                            JSONObject jsonObject = (JSONObject) response.get("data");

                                            String latitud = jsonObject.getString("latitud");
                                            String longitud = jsonObject.getString("longitud");

                                            if (latitud.isEmpty() && longitud.isEmpty() || latitud == null && longitud == null || latitud.equals("0") && longitud.equals("0") || latitud.equals("null") && longitud.equals("null")) {
                                                tvMapaAval.setText("");
                                            } else {
                                                tvMapaAval.setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View v) {
                                                        Log.d("qpwopeoqpww", "geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud);
                                                        Intent intent = new Intent(android.content.Intent.ACTION_VIEW);
                                                        intent.setData(Uri.parse("geo:" + latitud + "," + longitud + "?q=" + latitud + "," + longitud));
                                                        intent.setPackage("com.google.android.apps.maps");
                                                        context.startActivity(intent);
                                                    }
                                                });
                                            }
                                        }
                                    } catch (JSONException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            },
                            new Response.ErrorListener() {
                                @Override public void onErrorResponse(VolleyError error) { }
                            });

                    requestQueue.add(req2);


                    tvUbicacionCliente.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Intent i = new Intent(Intent.ACTION_VIEW,
                                    Uri.parse("google.navigation:q=" + prestamos.get(position).getLatitud() + "," + prestamos.get(position).getLongitud() + "&mode=d"));

                            i.setPackage("com.google.android.apps.maps");
                            context.startActivity(i);

                        }
                    });

                    tvTelefonoCliente.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Intent intent = new Intent(Intent.ACTION_DIAL);
                            intent.setData(Uri.parse("tel:" + prestamos.get(position).getTelefono_cliente()));
                            context.startActivity(intent);
                        }
                    });

                    tvTelefonoAval.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Intent intent = new Intent(Intent.ACTION_DIAL);
                            intent.setData(Uri.parse("tel:" + prestamos.get(position).getTelefono_aval()));
                            context.startActivity(intent);
                        }
                    });

                    new MaterialAlertDialogBuilder(context)
                            .setTitle("")
                            .setView(dialogView)
                            .setPositiveButton("Cerrar", (dialogInterface, i) -> {

                            })
                            .show();
                }
            });
            AlertDialog.Builder builder = new AlertDialog.Builder(context);

            btnVerPagos.setOnClickListener(view -> {
                String[] str;

                if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                        || sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                    str = new String[]{
                            "Pagar con folio",
                            "Ver semanas",
                            "Hacer comentario",
                            "Tomar fotos",
                            "Ver expediente",
                            "RMD",
                            "Ticket de aviso",
                    };
                } else {
                    str = new String[]{
                            "Pagar con folio",
                            "Ver semanas",
                            "Hacer comentario",
                            "Tomar fotos",
                            "Ver expediente",
                            "RMD"
                    };
                }

                String[] opciones = {"", "Efectivo", "Transferencia","Garantía"};
                new MaterialAlertDialogBuilder(context)
                        .setTitle("Opciones")
                        .setSingleChoiceItems(str, -1, (dialogInterface, i) -> {

                            switch (i) {

                                case 0:

                                    builder.setTitle(prestamos.get(position).getNombre_completo() + " DEL GRUPO " +
                                            prestamos.get(position).getGrupo_poblacion());

                                    final View dialogView = LayoutInflater.from(context).inflate(R.layout.dialog_pagar_con_folio, null);
                                    String[] semanasText = {""};
                                    builder.setView(dialogView);
                                    TextInputLayout tlFolio = dialogView.findViewById(R.id.tlFolio);
                                    TextInputLayout tlPagoRecibido = dialogView.findViewById(R.id.tlPagoRecibido);
                                    TextInputLayout tlConcepto = dialogView.findViewById(R.id.tlConcepto);
                                    TextView tvCantidadGarantias = dialogView.findViewById(R.id.tvCantidadGarantias);
                                    TextView tvIdGarantias = dialogView.findViewById(R.id.tvIdGarantias);
                                    EditText tvdescripcionGarantias = dialogView.findViewById(R.id.descripcionGarantias);
                                    Button btnRegistrarPago = dialogView.findViewById(R.id.btnRegistrarPago);
                                    btnCamGarantiasRetiradas = dialogView.findViewById(R.id.btnCamGarantiasRetiradas);
                                    Spinner spinnerOptions2 = dialogView.findViewById(R.id.spinnerOptions);
                                    btnToggleVisibility = dialogView.findViewById(R.id.btnToggleVisibility);
                                    btnToggleVisibility.setOnClickListener(new View.OnClickListener() {
                                        @Override
                                        public void onClick(View v) {
                                            if (isVisible) {
                                                tvdescripcionGarantias.setVisibility(View.GONE);
                                                btnToggleVisibility.setText(""); // O cambiar el ícono si lo prefieres
                                                btnToggleVisibility.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_eye, 0, 0, 0); // Ícono de ojo cerrado
                                            } else {
                                                tvdescripcionGarantias.setVisibility(View.VISIBLE);
                                                btnToggleVisibility.setText(""); // O cambiar el ícono si lo prefieres
                                                btnToggleVisibility.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_eye_closed, 0, 0, 0); // Ícono de ojo abierto
                                            }
                                            isVisible = !isVisible; // Alternar el estado
                                        }
                                    });

                                    final String[] pagoMulta = {"0.00"};
                                    CheckBox cbMulta = dialogView.findViewById(R.id.cbMulta);
                                    CheckBox cbPagarConGarantias = dialogView.findViewById(R.id.cbPagarConGarantias);
                                    ArrayAdapter<String> adapter2 = new ArrayAdapter<>(context, android.R.layout.simple_spinner_item, opciones);

                                    adapter2.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                                    spinnerOptions2.setAdapter(adapter2);
                                    TextView textPlaceholder = dialogView.findViewById(R.id.textPlaceholder);
                                    textPlaceholder.setOnClickListener(v -> {
                                        textPlaceholder.setVisibility(View.GONE);
                                        spinnerOptions2.performClick(); // Simula un clic en el Spinner al hacer clic en el TextView
                                    });

                                    btnRegistrarPago.setVisibility(View.GONE);

                                    getGarantias(prestamos.get(position).getCliente_id(),tvCantidadGarantias, cbPagarConGarantias, tvdescripcionGarantias, btnToggleVisibility, tvIdGarantias);

                                    spinnerOptions2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                                        @Override
                                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                                            String selectedOption = opciones[position];
                                            if (selectedOption.equals("Garantía")) {
                                                btnCamGarantiasRetiradas.setVisibility(View.VISIBLE);

                                                btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener() {
                                                    @Override
                                                    public void onClick(View view) {

                                                        AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                                        builder.setTitle("Seleccionar imagen");

                                                        final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                                                        builder.setItems(opciones, new DialogInterface.OnClickListener() {
                                                            @Override
                                                            public void onClick(DialogInterface dialogInterface, int which) {
                                                                switch (which) {
                                                                    case 0:
                                                                        int permisoCamara = ContextCompat.checkSelfPermission(context, Manifest.permission.CAMERA);
                                                                        int permisoAlmacen = ContextCompat.checkSelfPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                                                        if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {

                                                                            fragment.openCameraIntent();

                                                                        } else {
                                                                            ActivityCompat.requestPermissions((Activity) context,
                                                                                    new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                                                                    CODIGO_PERMISOS_CAMARA);
                                                                        }
                                                                        break;
                                                                    case 1:
                                                                        fragment.openGalleryIntent();
                                                                        break;
                                                                }
                                                            }
                                                        });
                                                        builder.show();
                                                    }
                                                });

                                            } else {
                                                btnCamGarantiasRetiradas.setVisibility(View.GONE);
                                            }
                                        }
                                        @Override
                                        public void onNothingSelected(AdapterView<?> parent) {
                                        }
                                    });

                                    siguienteFolio(tlFolio);
                                    cargarSemanas(prestamos.get(position).getId());
                                    semanasPendientes(prestamos.get(position).getId());

                                    cbMulta.setOnCheckedChangeListener((compoundButton, b) -> {
                                        if (b) {
                                            pagoMulta[0] = prestamos.get(position).getMonto_multa();
                                        } else {
                                            pagoMulta[0] = "0.00";
                                        }
                                    });

                                    tlPagoRecibido.getEditText().setHint("Pago Recibido ($" + prestamos.get(position).getPago_semanal() + ")");
                                    cbMulta.setText("Aplicar multa de $50.00");

                                    contenedorSemanas = dialogView.findViewById(R.id.contenedorSemanas);
                                    semanasGeneradas = new ArrayList<>();
                                    ArrayList<Semana> semanasElegidas = new ArrayList<>();
                                    final double[] totalPorPagar = {0};

                                    // Comienza el proceso de generación de botones de semanas
                                    for (int x = 0; x < Integer.parseInt(prestamos.get(position).getSemanas()); x++) {
                                        Semana sem = new Semana();
                                        sem.btnSemana = (Button) LayoutInflater.from(context).inflate(R.layout.boton_semana, null, false);
                                        sem.btnSemana.setText(String.valueOf(x + 1));
                                        sem.setSemana(String.valueOf(x + 1));
                                        sem.setCantidad_esperada_pago(prestamos.get(position).getPago_semanal());
                                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                            sem.btnSemana.setAutoSizeTextTypeUniformWithConfiguration(
                                                    4, // Tamaño mínimo en SP
                                                    10, // Tamaño máximo en SP
                                                    1,  // Incremento de tamaño en SP
                                                    TypedValue.COMPLEX_UNIT_SP
                                            );
                                        }
                                        sem.btnSemana.setSingleLine(false); // Permitir varias líneas
                                        sem.btnSemana.setEllipsize(TextUtils.TruncateAt.END); // Cortar texto largo con "..."
                                        int maxWidthPx = (int) (80 * sem.btnSemana.getContext().getResources().getDisplayMetrics().density);
                                        sem.btnSemana.setMaxWidth(maxWidthPx);
                                        sem.btnSemana.setGravity(Gravity.CENTER); // Asegurar que el texto esté centrado

                                        sem.setCantidad_pendiente("0.00");
                                        sem.btnSemana.setOnClickListener(view1 -> {
                                            if (semanasElegidas.contains(sem)) {
                                                // Código para revertir la selección de la semana
                                                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                                                    if (semanasNoPagadasList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                        sem.btnSemana.setBackgroundColor(context.getResources().getColor(R.color.danger_custom));
                                                        sem.btnSemana.setTextColor(context.getResources().getColor(R.color.white));
                                                    } else if (semanasPendientesList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                        sem.btnSemana.setBackgroundColor(context.getResources().getColor(R.color.success_custom));
                                                        sem.btnSemana.setTextColor(context.getResources().getColor(R.color.white));
                                                    } else if (semanasAdelantadasList.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {
                                                        sem.btnSemana.setBackgroundColor(context.getResources().getColor(R.color.secondary));
                                                        sem.btnSemana.setTextColor(context.getResources().getColor(R.color.white));
                                                    } else {
                                                        sem.btnSemana.setBackgroundColor(context.getResources().getColor(R.color.placeholder));
                                                        sem.btnSemana.setTextColor(context.getResources().getColor(R.color.black));
                                                    }
                                                }
                                                if (!sem.getCantidad_pendiente().equals("0.00")) {
                                                    totalPorPagar[0] -= Utils.convertirDouble(sem.getCantidad_pendiente());
                                                } else {
                                                    totalPorPagar[0] -= Utils.convertirDouble(sem.getCantidad_esperada_pago());
                                                }
                                                tlPagoRecibido.getEditText().setText((totalPorPagar[0] == 0.0 ? "" : String.valueOf(totalPorPagar[0])));
                                                semanasElegidas.remove(sem);
                                                tlPagoRecibido.getEditText().setEnabled(semanasElegidas.size() <= 1);
                                            } else {
                                                // Código para seleccionar la semana
                                                if (!sem.getCantidad_pendiente().equals("0.00")) {
                                                    totalPorPagar[0] += Utils.convertirDouble(sem.getCantidad_pendiente());
                                                } else {
                                                    totalPorPagar[0] += Utils.convertirDouble(sem.getCantidad_esperada_pago());
                                                }

                                                tlPagoRecibido.getEditText().setText((totalPorPagar[0] == 0.0 ? "" : String.valueOf(totalPorPagar[0])));
                                                sem.btnSemana.setBackgroundColor(ContextCompat.getColor(context,R.color.primary));
                                                sem.btnSemana.setTextColor(ContextCompat.getColor(context,R.color.white));
                                                semanasElegidas.add(sem);
                                                tlPagoRecibido.getEditText().setEnabled(semanasElegidas.size() <= 1);
                                            }
                                        });

                                        semanasGeneradas.add(sem);
                                        contenedorSemanas.addView(sem.btnSemana);
                                    }

                                    builder.setCancelable(false);
                                    // Dentro del método onClick del botón "Pagar"
                                    builder.setPositiveButton("Pagar", (dialogInterface13, i13) -> {

                                        if (cbPagarConGarantias.isChecked()) {
                                            // Mostrar un modal con un formulario
                                            AlertDialog.Builder formBuilder = new AlertDialog.Builder(context);
                                            View formView = LayoutInflater.from(context).inflate(R.layout.formulario_layout, null);
                                            formBuilder.setView(formView);

                                            // Configurar los campos del formulario
                                            final EditText etFechaVenta = formView.findViewById(R.id.etFechaVenta);
                                            final Spinner spinnerLugarVenta = formView.findViewById(R.id.spinnerLugarVenta);
                                            final EditText etImporte = formView.findViewById(R.id.etImporte);
                                            final EditText etComentarios = formView.findViewById(R.id.etComentarios);
                                            final Button btnSubmit = formView.findViewById(R.id.btnSubmit);
                                            final TextView tvSemanas = formView.findViewById(R.id.tvSemanas);

                                            // Mostrar las semanas seleccionadas
                                            List<String> semanasList = new ArrayList<>();
                                            for (Semana semana : semanasElegidas) {
                                                semanasList.add(String.valueOf(semana.getSemana()));
                                            }
                                            semanasText[0] = "Semanas: " + String.join(",", semanasList);
                                            tvSemanas.setText(semanasText[0]);

                                            // Establecer la fecha actual en el campo de fecha de venta
                                            final Calendar calendar = Calendar.getInstance();
                                            int year = calendar.get(Calendar.YEAR);
                                            int month = calendar.get(Calendar.MONTH);
                                            int day = calendar.get(Calendar.DAY_OF_MONTH);
                                            String currentDate = day + "/" + (month + 1) + "/" + year;
                                            etFechaVenta.setText(currentDate);

                                            // Configurar el OnClickListener para el campo de fecha
                                            etFechaVenta.setOnClickListener(v -> {
                                                DatePickerDialog datePickerDialog = new DatePickerDialog(context,
                                                        (view2, year1, month1, dayOfMonth) -> {
                                                            String selectedDate = dayOfMonth + "/" + (month1 + 1) + "/" + year1;
                                                            etFechaVenta.setText(selectedDate);
                                                        }, year, month, day);
                                                datePickerDialog.show();
                                            });
                                            // Configurar el Spinner
                                            ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(context,
                                                    R.array.lugar_venta_array, android.R.layout.simple_spinner_item);
                                            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);

                                            spinnerLugarVenta.setAdapter(adapter);
                                            spinnerLugarVenta.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                                                @Override
                                                public void onItemSelected(AdapterView<?> parentView, View selectedItemView, int position, long id) {
                                                    int selectedPosition = position + 1;
                                                    Log.d("SpinnerSelection", "Selected position: " + selectedPosition);
                                                    //String lugarVenta = spinnerLugarVenta.getSelectedItem().toString();
                                                }
                                                @Override
                                                public void onNothingSelected(AdapterView<?> parentView) {
                                                }
                                            });
                                            formBuilder.setTitle("Formulario de Garantías");
                                            formBuilder.setNegativeButton("Cancelar", (dialog, which) -> dialog.dismiss());

                                            AlertDialog formDialog = formBuilder.create();
                                            formDialog.show();
                                            if (semanasElegidas.size() != 0) {
                                                buscarGarantia(prestamos.get(position).getCliente_id());
                                                Log.d("CACHE", "Total semanasElegidas.size(): " + semanasElegidas);
                                                int pagoSemanal = (int) Utils.convertirDouble(prestamos.get(position).getPago_semanal());
                                                String tipo_pagoop = spinnerOptions2.getSelectedItem().toString();
                                                int numeroSemanasElegidas = semanasElegidas.size();
                                                int smonto = pagoSemanal * numeroSemanasElegidas;
                                                etImporte.setText(String.valueOf(smonto));
                                                String importe = etImporte.getText().toString();
                                                Log.d("CACHE", "Total importe.size(): " + importe);
                                                btnSubmit.setOnClickListener(v -> {
                                                    // Obtener datos del formulario
                                                    String fechaVenta = etFechaVenta.getText().toString();
                                                    String semanasText2 = tvSemanas.getText().toString();
                                                    String idretiradas = tvIdGarantias.getText().toString();
                                                    String semanas = semanasText2.replace("Semanas: ", "").trim();
                                                    String concepto = tlConcepto.getEditText().getText().toString();
                                                    String folio = tlFolio.getEditText().getText().toString();
                                                    String importev = etImporte.getText().toString();
                                                    String lugarVenta = spinnerLugarVenta.getSelectedItem().toString();
                                                    // Obtener la posición seleccionada del spinner
                                                    int lugarVentaPosition = spinnerLugarVenta.getSelectedItemPosition() + 1; // Sumar 1 para que empiece desde 1 en lugar de 0

                                                    String comentarios = etComentarios.getText().toString();

                                                    // Validar datos
                                                    if (fechaVenta.isEmpty() || importe.isEmpty()) {
                                                        Toast.makeText(context, "Por favor, complete todos los campos requeridos.", Toast.LENGTH_SHORT).show();
                                                    } else {

                                                        registrarVenta(Integer.parseInt(prestamos.get(position).getId()),fechaVenta, lugarVentaPosition, importev, prestamos.get(position).getNumero_tarjeton(), semanas, comentarios, idretiradas, numeroSemanasElegidas,pagoMulta[0],tipo_pagoop,concepto,folio);
                                                        // Mostrar un mensaje de confirmación
                                                        Toast.makeText(context, "Formulario enviado con éxito.", Toast.LENGTH_SHORT).show();

                                                        // Cerrar el diálogo
                                                        formDialog.dismiss();
                                                    }
                                                });
                                            } else {
                                                formDialog.dismiss();
                                                Toast.makeText(context, "Debes elegir una o más semanas a pagar", Toast.LENGTH_SHORT).show();
                                            }
                                        }
                                        else
                                        {
                                            // Mostrar las semanas seleccionadas
                                            List<String> semanasList = new ArrayList<>();
                                            for (Semana semana : semanasElegidas) {
                                                semanasList.add(String.valueOf(semana.getSemana()));
                                            }
                                            semanasText[0] = "Semanas: " + String.join(",", semanasList);
                                            Log.d("Debug", "cantidadTotalGarantias: " + cantidadTotalGarantias);
                                            Log.d("Debug", "semanasText[0]: " + semanasText[0]);
                                            Log.d("Debug", "cbPagarConGarantias isChecked: " + cbPagarConGarantias.isChecked());

                                            if (cantidadTotalGarantias>0 && semanasText[0].contains("15") && !cbPagarConGarantias.isChecked()) {

                                                Toast.makeText(context, "El cliente cuenta con 1 o mas garantias retiradas disponibles", Toast.LENGTH_SHORT).show();
                                            }
                                            else {
                                                // Procesar el pago normalmente si el CheckBox no está marcado
                                                if (semanasElegidas.size() != 0) {
                                                    String concepto = tlConcepto.getEditText().getText().toString();
                                                    String folio = tlFolio.getEditText().getText().toString();
                                                    String pago_recibido = tlPagoRecibido.getEditText().getText().toString();
                                                    String tipo_pagoop = spinnerOptions2.getSelectedItem().toString();

                                                    if (semanasElegidas.size() == 1) {
                                                        semanasElegidas.get(0).setCantidad_pendiente(pago_recibido);
                                                    }

                                                    Toast.makeText(context, "Guardando, por favor espere...", Toast.LENGTH_SHORT).show();
                                                    dialogInterface.dismiss();

                                                    for (Semana semanaElegida : semanasElegidas) {

                                                        if (!semanaElegida.getCantidad_pendiente().equals("0.00")) {
                                                            Prestamo prestamo = prestamos.get(position);
                                                            pagar(prestamo, prestamos.get(position).getId(), semanaElegida.getCantidad_pendiente(), pagoMulta[0], concepto, "", folio, semanaElegida.getSemana(), tipo_pagoop, prestamos.get(position));
                                                            getFecha(prestamos.get(position).getId(), semanaElegida.getSemana());
                                                        } else {
                                                            Prestamo prestamo = prestamos.get(position);
                                                            pagar(prestamo, prestamos.get(position).getId(), semanaElegida.getCantidad_esperada_pago(), pagoMulta[0], concepto, "", folio, semanaElegida.getSemana(), tipo_pagoop, prestamos.get(position));
                                                            getFecha(prestamos.get(position).getId(), semanaElegida.getSemana());
                                                        }

                                                    }

                                                    double pago = Utils.convertirDouble(pago_recibido);
                                                    NumeroLetras numeroLetras = new NumeroLetras();
                                                    String recibido_con_letra = numeroLetras.Convertir(pago + "", "", "", "", "", "", true);

                                                    Date c = Calendar.getInstance().getTime();
                                                    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                                                    String formattedDate = df.format(c);

                                                    AlertDialog.Builder builder6 = new AlertDialog.Builder(context);
                                                    builder6.setTitle("Seleccionar Opción")
                                                            .setPositiveButton("Imprimir Pago", (dialog, which) -> {
                                                                try {
                                                                    BluetoothUtils.context = context;
                                                                    BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                                                                    BluetoothUtils.printText(prestamos.get(position), folio, pago + "", pagoMulta[0], concepto, formattedDate, recibido_con_letra);
                                                                } catch (Exception e) {
                                                                    e.printStackTrace();
                                                                }
                                                            })
                                                            .setNeutralButton("Compartir", (dialog, which) -> {
                                                                String tipo_ticket = "Pago";
                                                                fragment.compartirTextoPago(prestamos.get(position), folio, pago + "", pagoMulta[0], concepto, formattedDate, recibido_con_letra, tipo_ticket);
                                                            })
                                                            .setNegativeButton("Cerrar", (dialog, which) -> dialog.dismiss())
                                                            .show();

                                                    semanasElegidas.clear();
                                                    semanasPagadasList.clear();
                                                    semanasPagadasConMultaList.clear();
                                                    semanasNoPagadasList.clear();

                                                    dialogInterface13.cancel();

                                                } else {
                                                    Toast.makeText(context, "Debes elegir una o más semanas a pagar", Toast.LENGTH_SHORT).show();
                                                }
                                            }
                                        }
                                    });

                                    builder.setNegativeButton("Cancelar", (dialogInterface14, i14) -> {

                                    });

                                    builder.show();
                                    break;


                                case 1:

                                    final View dialogView2 = LayoutInflater.from(context).inflate(R.layout.fragment_pagos, null);

                                    Button btnPagar, btnPagarConMulta, btnNoPagar, btnAdelantar;
                                    TextInputEditText tvSemana;
                                    final Pago[] pagoSeleccionado = new Pago[1];
                                    //cargarPrestamosConsulta();
                                    Log.d("DATA", "Datos almacenados en pagos ANTES" + pagos);

                                    pagos = new ArrayList<Pago>();

                                    Log.d("DATA", "Datos almacenados en pagos DESPUES" + pagos);
                                    recyclerViewPagos = dialogView2.findViewById(R.id.rvPagos);
                                    shimmer = dialogView2.findViewById(R.id.sfPagos);
                                    btnPagar = dialogView2.findViewById(R.id.btnPagar);
                                    btnPagarConMulta = dialogView2.findViewById(R.id.btnPagarConMulta);
                                    btnNoPagar = dialogView2.findViewById(R.id.btnNoPagar);

                                    ////NUEVO BOTON PARA ADELANTAR PAGOS

                                    btnAdelantar = dialogView2.findViewById(R.id.btnAdelantarPagoVerSemanas);
                                    btnAdelantar.setOnClickListener(view1 -> {
                                        if (pagosAdapter != null && pagosAdapter.pagosSeleccionados.size() > 0) {
                                            // Crear el cuadro de diálogo
                                            MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(context);
                                            builder2.setTitle("Adelantar pago de la semana " + pagosAdapter.pagosSeleccionados.size());

                                            // Inflar el diseño del cuadro de diálogo que contiene el Spinner
                                            LayoutInflater inflater = LayoutInflater.from(context);
                                            View dialogView4 = inflater.inflate(R.layout.dialog_tipo_pago, null);
                                            builder2.setView(dialogView4);
                                            btnCamGarantiasRetiradas = dialogView4.findViewById(R.id.btnCamGarantiasRetiradas);
                                            // Obtener referencia al Spinner en el diseño del cuadro de diálogo
                                            Spinner spinnerOptions = dialogView4.findViewById(R.id.spinnerOptions);
                                            TextView textPlaceholder2 = dialogView4.findViewById(R.id.textPlaceholder);
                                            textPlaceholder2.setOnClickListener(v -> {
                                                textPlaceholder2.setVisibility(View.GONE);
                                                spinnerOptions.performClick(); // Simula un clic en el Spinner al hacer clic en el TextView
                                            });
                                            // Configurar el Adapter para el Spinner
                                            ArrayAdapter<String> adapter = new ArrayAdapter<>(context, android.R.layout.simple_spinner_item, opciones);
                                            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                                            spinnerOptions.setAdapter(adapter);
                                            spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                                                @Override
                                                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                                                    String selectedOption = opciones[position];
                                                    if (selectedOption.equals("Garantía")) {
                                                        btnCamGarantiasRetiradas.setVisibility(View.VISIBLE);
                                                        btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener() {
                                                            @Override
                                                            public void onClick(View view) {

                                                                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                                                builder.setTitle("Seleccionar imagen");

                                                                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                                                                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                                                                    @Override
                                                                    public void onClick(DialogInterface dialogInterface, int which) {
                                                                        switch (which) {
                                                                            case 0:
                                                                                int permisoCamara = ContextCompat.checkSelfPermission(context, Manifest.permission.CAMERA);
                                                                                int permisoAlmacen = ContextCompat.checkSelfPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                                                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                                                                    fragment.openCameraIntent();
                                                                                } else {
                                                                                    ActivityCompat.requestPermissions((Activity) context,
                                                                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                                                                            CODIGO_PERMISOS_CAMARA);
                                                                                }
                                                                                break;
                                                                            case 1:
                                                                                fragment.openGalleryIntent();
                                                                                break;
                                                                        }
                                                                    }
                                                                });
                                                                builder.show();
                                                            }
                                                        });

                                                    } else {
                                                        btnCamGarantiasRetiradas.setVisibility(View.GONE);
                                                    }
                                                }
                                                @Override
                                                public void onNothingSelected(AdapterView<?> parent) {
                                                }
                                            });
                                            // Configurar el botón positivo del cuadro de diálogo
                                            builder2.setPositiveButton("Pagar", (dialogInterface15, i15) -> {
                                                prestamo_id= Integer.parseInt(prestamos.get(position).getId());
                                                String pagoSemanal= prestamos.get(position).getPago_semanal();
                                                pagoSemanal= pagoSemanal+".00";

                                                Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoSemanal );
                                                Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + prestamos.get(position).getPago_semanal() );
                                                String tipo_pago = (String) spinnerOptions.getSelectedItem();
                                                for (Pago pago : pagosAdapter.pagosSeleccionados) {
                                                    AdelantarpagarSemana(prestamos.get(position), pago.getSemana(), "4",tipo_pago,pagoSemanal);
                                                }
                                                pagosAdapter.pagosSeleccionados.clear();
                                            }).show();
                                        } else {
                                            Toast.makeText(context, "Selecciona al menos una semana", Toast.LENGTH_SHORT).show();
                                        }
                                    });

                                    ////FIN NUEVO BOTON PARA ADELANTAR PAGOS

                                    btnPagar.setOnClickListener(view1 -> {
                                        if (pagosAdapter != null && pagosAdapter.pagosSeleccionados.size() > 0) {
                                            // Crear el cuadro de diálogo
                                            MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(context);
                                            builder2.setTitle("Pagar " + pagosAdapter.pagosSeleccionados.size() + " semanas");

                                            // Inflar el diseño del cuadro de diálogo que contiene el Spinner
                                            LayoutInflater inflater = LayoutInflater.from(context);
                                            View dialogView4 = inflater.inflate(R.layout.dialog_tipo_pago, null);
                                            builder2.setView(dialogView4);
                                            btnCamGarantiasRetiradas = dialogView4.findViewById(R.id.btnCamGarantiasRetiradas);
                                            // Obtener referencia al Spinner en el diseño del cuadro de diálogo
                                            Spinner spinnerOptions = dialogView4.findViewById(R.id.spinnerOptions);
                                            TextView textPlaceholder2 = dialogView4.findViewById(R.id.textPlaceholder);
                                            textPlaceholder2.setOnClickListener(v -> {
                                                textPlaceholder2.setVisibility(View.GONE);
                                                spinnerOptions.performClick(); // Simula un clic en el Spinner al hacer clic en el TextView
                                            });
                                            // Configurar el Adapter para el Spinner
                                            ArrayAdapter<String> adapter = new ArrayAdapter<>(context, android.R.layout.simple_spinner_item, opciones);
                                            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                                            spinnerOptions.setAdapter(adapter);
                                            spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                                                @Override
                                                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                                                    String selectedOption = opciones[position];
                                                    if (selectedOption.equals("Garantía")) {
                                                        btnCamGarantiasRetiradas.setVisibility(View.VISIBLE);
                                                        btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener() {
                                                            @Override
                                                            public void onClick(View view) {

                                                                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                                                builder.setTitle("Seleccionar imagen");

                                                                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                                                                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                                                                    @Override
                                                                    public void onClick(DialogInterface dialogInterface, int which) {
                                                                        switch (which) {
                                                                            case 0:
                                                                                int permisoCamara = ContextCompat.checkSelfPermission(context, Manifest.permission.CAMERA);
                                                                                int permisoAlmacen = ContextCompat.checkSelfPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                                                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                                                                    fragment.openCameraIntent();
                                                                                } else {
                                                                                    ActivityCompat.requestPermissions((Activity) context,
                                                                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                                                                            CODIGO_PERMISOS_CAMARA);
                                                                                }
                                                                                break;
                                                                            case 1:
                                                                                fragment.openGalleryIntent();
                                                                                break;
                                                                        }
                                                                    }
                                                                });
                                                                builder.show();
                                                            }
                                                        });

                                                    } else {
                                                        btnCamGarantiasRetiradas.setVisibility(View.GONE);
                                                    }
                                                }
                                                @Override
                                                public void onNothingSelected(AdapterView<?> parent) {
                                                }
                                            });
                                            // Configurar el botón positivo del cuadro de diálogo
                                            builder2.setPositiveButton("Pagar", (dialogInterface15, i15) -> {
                                                prestamo_id= Integer.parseInt(prestamos.get(position).getId());
                                                String pagoSemanal= prestamos.get(position).getPago_semanal();
                                                pagoSemanal= pagoSemanal+".00";

                                                Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoSemanal );
                                                Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + prestamos.get(position).getPago_semanal() );
                                                String tipo_pago = (String) spinnerOptions.getSelectedItem();
                                                for (Pago pago : pagosAdapter.pagosSeleccionados) {
                                                    pagarSemana(prestamos.get(position), pago.getSemana(), pago.getStatus(),tipo_pago,pagoSemanal);
                                                }
                                                pagosAdapter.pagosSeleccionados.clear();
                                            }).show();
                                        } else {
                                            Toast.makeText(context, "Selecciona al menos una semana", Toast.LENGTH_SHORT).show();
                                        }
                                    });

                                    btnPagarConMulta.setOnClickListener(view1 -> {
                                        if (pagosAdapter != null && pagosAdapter.pagosSeleccionados.size() > 0) {
                                            // Crear el cuadro de diálogo
                                            MaterialAlertDialogBuilder builder2 = new MaterialAlertDialogBuilder(context);
                                            builder2.setTitle("Pagar " + pagosAdapter.pagosSeleccionados.size() + " semanas con multa");

                                            // Inflar el diseño del cuadro de diálogo que contiene el Spinner
                                            LayoutInflater inflater = LayoutInflater.from(context);
                                            View dialogView4 = inflater.inflate(R.layout.dialog_tipo_pago, null);
                                            builder2.setView(dialogView4);
                                            btnCamGarantiasRetiradas = dialogView4.findViewById(R.id.btnCamGarantiasRetiradas);

                                            // Obtener referencia al Spinner en el diseño del cuadro de diálogo
                                            Spinner spinnerOptions = dialogView4.findViewById(R.id.spinnerOptions);
                                            TextView textPlaceholder2 = dialogView4.findViewById(R.id.textPlaceholder);
                                            textPlaceholder2.setOnClickListener(v -> {
                                                textPlaceholder2.setVisibility(View.GONE);
                                                spinnerOptions.performClick(); // Simula un clic en el Spinner al hacer clic en el TextView
                                            });
                                            // Configurar el Adapter para el Spinner
                                            ArrayAdapter<String> adapter = new ArrayAdapter<>(context, android.R.layout.simple_spinner_item, opciones);
                                            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                                            spinnerOptions.setAdapter(adapter);
                                            spinnerOptions.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                                                @Override
                                                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                                                    String selectedOption = opciones[position];
                                                    if (selectedOption.equals("Garantía")) {
                                                        btnCamGarantiasRetiradas.setVisibility(View.VISIBLE);
                                                        btnCamGarantiasRetiradas.setOnClickListener(new View.OnClickListener() {
                                                            @Override
                                                            public void onClick(View view) {

                                                                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                                                                builder.setTitle("Seleccionar imagen");

                                                                final String[] opciones = {"Tomar foto", "Seleccionar de galería"};
                                                                builder.setItems(opciones, new DialogInterface.OnClickListener() {
                                                                    @Override
                                                                    public void onClick(DialogInterface dialogInterface, int which) {
                                                                        switch (which) {
                                                                            case 0:
                                                                                int permisoCamara = ContextCompat.checkSelfPermission(context, Manifest.permission.CAMERA);
                                                                                int permisoAlmacen = ContextCompat.checkSelfPermission(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);

                                                                                if (permisoCamara == PackageManager.PERMISSION_GRANTED && permisoAlmacen == PackageManager.PERMISSION_GRANTED) {
                                                                                    fragment.openCameraIntent();
                                                                                } else {
                                                                                    ActivityCompat.requestPermissions((Activity) context,
                                                                                            new String[]{Manifest.permission.CAMERA, Manifest.permission.WRITE_EXTERNAL_STORAGE},
                                                                                            CODIGO_PERMISOS_CAMARA);
                                                                                }
                                                                                break;
                                                                            case 1:
                                                                                fragment.openGalleryIntent();
                                                                                break;
                                                                        }
                                                                    }
                                                                });
                                                                builder.show();
                                                            }
                                                        });
                                                    } else {
                                                        btnCamGarantiasRetiradas.setVisibility(View.GONE);
                                                    }
                                                }
                                                @Override
                                                public void onNothingSelected(AdapterView<?> parent) {
                                                }
                                            });
                                            // Configurar el botón positivo del cuadro de diálogo
                                            builder2.setPositiveButton("Pagar", (dialogInterface16, i16) -> {
                                                        prestamo_id= Integer.parseInt(prestamos.get(position).getId());
                                                        String pagoSemanal= prestamos.get(position).getPago_semanal();
                                                        pagoSemanal= pagoSemanal+".00";

                                                        String pagoMultaLocal = prestamos.get(position).getMonto_multa();

                                                        Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + pagoMultaLocal );
                                                        Log.d("SQLite", "Pago ANTES correctamente en SQLite para pagoSemanal:........................... " + prestamos.get(position).getMonto_multa() );

                                                        String tipo_pago = (String) spinnerOptions.getSelectedItem();
                                                        for (Pago pago : pagosAdapter.pagosSeleccionados) {
                                                            pagarConMultaSemana(prestamos.get(position), pago.getSemana(), tipo_pago, pagoSemanal, pagoMultaLocal);
                                                        }
                                                        pagosAdapter.pagosSeleccionados.clear();
                                                    })
                                                    .show();
                                        } else {
                                            Toast.makeText(context, "Selecciona al menos una semana", Toast.LENGTH_SHORT).show();
                                        }
                                    });

                                    btnNoPagar.setOnClickListener(view1 -> {
                                        if (pagosAdapter.pagosSeleccionados.size() > 0) {
                                            new MaterialAlertDialogBuilder(context)
                                                    .setTitle("Marcar " + pagosAdapter.pagosSeleccionados.size() + " semanas como no pagadas")
                                                    .setPositiveButton("No pagar", (dialogInterface17, i17) -> {

                                                        for (Pago pago : pagosAdapter.pagosSeleccionados) {
                                                            prestamo_id= Integer.parseInt(prestamos.get(position).getId());
                                                            noPagarSemana(prestamos.get(position), pago.getSemana(), pago.getTipo_pago());
                                                        }
                                                        pagosAdapter.pagosSeleccionados.clear();
                                                    })
                                                    .show();
                                        } else {
                                            Toast.makeText(context, "Selecciona al menos una semana", Toast.LENGTH_SHORT).show();
                                        }
                                    });
                                    pagosAdapter = new PagosAdapter(context, pagos, prestamos.get(position));
                                    getPagos(prestamos.get(position).getId());
                                    pagosAdapter = new PagosAdapter(context, pagos, prestamos.get(position));
                                    linearLayoutManager = new LinearLayoutManager(context);
                                    recyclerViewPagos.setLayoutManager(linearLayoutManager);

                                    recyclerViewPagos.setAdapter(pagosAdapter);
                                    recyclerViewPagos.getRecycledViewPool().setMaxRecycledViews(0, 0);

                                    AlertDialog.Builder builder2 = new AlertDialog.Builder(context);

                                    builder2.setTitle(prestamos.get(position).getNombre_completo() + " DEL GRUPO " +
                                            prestamos.get(position).getGrupo_poblacion());

                                    builder2.setView(dialogView2);

                                    builder2.setCancelable(false);
                                    builder2.setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialogInterface, int i) {

                                        }
                                    });

                                    builder2.show();

                                    break;

                                case 2:

                                    final View dialogView3 = LayoutInflater.from(context).inflate(R.layout.dialog_comentar, null);

                                    TextInputLayout tlComentario;
                                    TextView tvModificacion;
                                    tlComentario = dialogView3.findViewById(R.id.tlComentario);
                                    tvModificacion = dialogView3.findViewById(R.id.tvModificacion);

                                    AlertDialog.Builder builder3 = new AlertDialog.Builder(context);

                                    builder3.setTitle("HACE COMENTARIO A " + prestamos.get(position).getNombre_completo() + " DEL GRUPO " +
                                            prestamos.get(position).getGrupo_poblacion());

                                    tlComentario.getEditText().setText(prestamos.get(position).getComentario());
                                    tvModificacion.setText((prestamos.get(position).getComentario_fecha() == null ? "" : "Última modifcación: " + prestamos.get(position).getComentario_fecha()));

                                    builder3.setView(dialogView3);

                                    builder3.setCancelable(false);
                                    builder3.setPositiveButton("Guardar", (dialogInterface1, i1) -> hacerComentario(prestamos.get(position), tlComentario.getEditText().getText().toString()));
                                    builder3.setNegativeButton("Cerrar", (dialogInterface12, i12) -> {

                                    });

                                    builder3.show();


                                    break;

                                case 3:

                                    dialogInterface.dismiss();

                                    Bundle args2 = new Bundle();

                                    String idCliente = prestamos.get(position).getCliente_id();
                                    String prestamoAvalNombre = prestamos.get(position).getNombre_aval();

                                    // Crear una instancia de tu base de datos
                                    DatabaseHelper clienteMigration = new DatabaseHelper(context);
                                    SQLiteDatabase db = clienteMigration.getReadableDatabase();

                                    // Obtener los datos del cliente por ID
                                    Cliente cliente = clienteMigration.getClienteById(db, idCliente);
                                    String personJsonString2 = Utils.getGsonParser().toJson(cliente);

                                    args2.putString("cliente", personJsonString2);
                                    args2.putString("avalNombre", prestamoAvalNombre);
                                    Log.d("DEBUG1", "ARREGLO EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................"+ cliente);
                                    Log.d("DEBUG1", "prestamoAvalNombre EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................"+ prestamoAvalNombre);
                                    /*Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard)
                                            .navigate(R.id.nav_clientes_fotos, args2);*/
                                    CustomDialogFragment2 dialogFragment2 = new CustomDialogFragment2();
                                    dialogFragment2.setArguments(args2);
                                    dialogFragment2.show(((FragmentActivity) context).getSupportFragmentManager(), "CustomDialogFragment");
                                    break;

                                case 4:
                                    dialogInterface.dismiss();

                                    Bundle args = new Bundle();
                                    String personJsonString = Utils.getGsonParser().toJson(prestamos.get(position));
                                    String personJsonString3 = prestamos.get(position).getCliente_id();
                                    args.putString("cliente", personJsonString);
                                    args.putString("clienteId", personJsonString3);
                                    Log.d("DEBUG1", "ARREGLO EN A ENVIAR DE PRESTAMOS A CLIENTES DOCUMENTOS................"+personJsonString);
                                    CustomDialogFragment dialogFragment = new CustomDialogFragment();
                                    dialogFragment.setArguments(args);
                                    dialogFragment.show(((FragmentActivity) context).getSupportFragmentManager(), "CustomDialogFragment");

                                    break;

                                case 5:
                                    dialogInterface.dismiss();
                                    String prestamoId = prestamos.get(position).getId();

                                    SharedPreferences sesion = context.getSharedPreferences("sesion", Context.MODE_PRIVATE);
                                    String empleado_id = sesion.getString("id", null);
                                    RMDController rmdC = new RMDController(context, null);
                                    String rmdCount = rmdC.getRMDSCount(empleado_id);

                                    if (Objects.equals(rmdCount, "0")) {
                                        if (NetworkChange.isConnectedToInternet(context)) {
                                            AlertDialog.Builder builderCantidad = new AlertDialog.Builder(context);
                                            View dialogLayout = LayoutInflater.from(context).inflate(R.layout.preraparfolio, null);
                                            builderCantidad.setView(dialogLayout);

                                            final TextInputLayout tlCantidad = dialogLayout.findViewById(R.id.tlCantidad);

                                            builderCantidad.setTitle("Preparar RMDs")
                                                    .setPositiveButton("Crear", new DialogInterface.OnClickListener() {
                                                        @Override
                                                        public void onClick(DialogInterface dialog, int id) {
                                                            rmdC.prepararRMDS(tlCantidad.getEditText().getText().toString(), empleado_id, new RMDController.prerararRMDSCallback() {
                                                                @Override
                                                                public void onSuccess(String response) {
                                                                    dialog.dismiss();
                                                                    Bundle bundle = new Bundle();
                                                                    bundle.putString("prestamoId", prestamoId);

                                                                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard).navigate(R.id.crearRMDFragment, bundle);
                                                                }

                                                                @Override
                                                                public void onError(String error) {

                                                                }

                                                                @Override
                                                                public void onSucess() {
                                                                    dialog.dismiss();
                                                                    Bundle bundle = new Bundle();
                                                                    bundle.putString("prestamoId", prestamoId);

                                                                    Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard).navigate(R.id.crearRMDFragment, bundle);
                                                                }
                                                            });

                                                        }
                                                    })
                                                    .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                                        public void onClick(DialogInterface dialog, int id) {
                                                            dialog.dismiss();
                                                        }
                                                    });

                                            AlertDialog dialog = builderCantidad.create();
                                            dialog.show();
                                        } else {
                                            AlertDialog.Builder builderInternet = new AlertDialog.Builder(context);
                                            builderInternet.setTitle("No hay conexión a internet")
                                                    .setMessage("No se pueden preparar RMDs")
                                                    .setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                                        public void onClick(DialogInterface dialog, int id) {
                                                            dialog.dismiss();
                                                        }
                                                    });

                                            AlertDialog dialog = builderInternet.create();
                                            dialog.show();
                                        }
                                    } else {
                                        Bundle bundle = new Bundle();
                                        bundle.putString("prestamoId", prestamoId);

                                        Navigation.findNavController((Activity) context, R.id.nav_host_fragment_content_dashboard).navigate(R.id.crearRMDFragment, bundle);
                                    }
                                    break;

                                case 6:
                                    dialogInterface.dismiss();
                                    pagos2 = new ArrayList<Pago>();
                                    pagosAdapter = new PagosAdapter(context, pagos2, prestamos.get(position));
                                    getPagos2(prestamos.get(position).getId(), position);
                                    break;
                            }
                        })
                        .show();
            });

            PrestamoController pc = new PrestamoController(context);
            String status = pc.getStatus(prestamos.get(position).getId());
            if (Objects.equals(status, "4")) {
                prestamo_item_bg.setBackgroundColor(ContextCompat.getColor(context,R.color.secondary));
                tvTarjetonPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvClientePrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
                tvMontoPrestamo.setTextColor(ContextCompat.getColor(context,R.color.white));
            }
        }
        private void CambiarAval(String prestamo_id, String aval_id) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            try {
                data.put("func", "CambiarAvalPrestamo");
                data.put("id", prestamo_id);
                data.put("aval_id", aval_id);

            } catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d("DEBUG", "El aval_id DESPUES de guardar es: " + aval_id);
            Log.d("DEBUG", "El prestamo_id DESPUES de guardar es: " + prestamo_id);
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Toast.makeText(context, "Se ha cambiado el AVAL", Toast.LENGTH_SHORT).show();
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }
        private void cargarPrestamosConsulta() {
            //verificarClientesDuplicados();
            ExecutorService executor = Executors.newSingleThreadExecutor();  // Executor para tareas en segundo plano

            executor.execute(() -> {
                DatabaseHelper dbHelper = new DatabaseHelper(context);
                SQLiteDatabase db = dbHelper.getReadableDatabase();
                Log.d("PagosWorker", "Entro en LA CONSULTA SQL DESDE ADAPTER.............................");
                //verificarConfiguracionSemanas(db);
                // Consulta SQL con JOIN para obtener todos los campos necesarios desde varias tablas
                String query = "SELECT prestamos.id, prestamos.cliente_id, clientes.nombre_completo, clientes.direccion, " +
                        "clientes.telefono, clientes.garantias, prestamos.status, prestamos.fecha_prestamo, prestamos.monto_prestado, " +
                        "colocadoras.nombre_completo AS nombre_colocadora, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, " +
                        "avales.telefono AS telefono_aval, rutas.nombre_ruta AS nombre_ruta, poblaciones.nombre_poblacion AS nombre_poblacion, " +
                        "poblaciones.monto_multa, configuracion_semanas.cantidad AS semanas, " +
                        "MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 14 and prestamos.modalidad_semanas = 1 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_14, " +
                        "MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 19 and prestamos.modalidad_semanas = 2 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_19, " +
                        "COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) as tiene_pendientes, " +
                        "COUNT(CASE WHEN pagos.status = 3 THEN pagos.id END) AS tiene_multas, " +
                        "COUNT(CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) as tiene_folios, " +
                        "prestamos.created_at, prestamos.updated_at, " +
                        "prestamos.numero_tarjeton, " +
                        "poblaciones.grupo, " +
                        "avales.garantias AS garantias_aval, " +
                        "avales.otras_referencias  AS otras_referencias_aval, " +
                        "prestamos.pago_semanal, " +
                        "clientes.ruta_id, " +
                        "clientes.poblacion_id, " +
                        "prestamos.modalidad_semanas, " +
                        "prestamos.aval_id " +
                        "FROM prestamos " +
                        "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                        "LEFT JOIN colocadoras ON clientes.colocadora_id = colocadoras.id " +
                        "LEFT JOIN avales ON prestamos.aval_id = avales.id " +
                        "LEFT JOIN rutas ON clientes.ruta_id = rutas.id " +
                        "LEFT JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                        "LEFT JOIN configuracion_semanas ON prestamos.modalidad_semanas = configuracion_semanas.id " +
                        "LEFT JOIN pagos ON prestamos.id = pagos.prestamo_id " +
                        "WHERE prestamos.status NOT IN (1, 2) " +
                        "GROUP BY prestamos.id " +
                        "ORDER BY prestamos.id DESC";
                // Ejecutar la consulta
                Cursor cursor = db.rawQuery(query, null);
                //Log.d("PrestamosWorker", "Total de registros en LISTA prestamos ANTES DE CONSULTA: " + prestamos);
                prestamos.clear(); // Limpiar lista en caso de recarga
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                        String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));

                        // Validar que el campo "id" no sea null o vacío
                        if (prestamoId != null && !prestamoId.isEmpty() && clienteId != null && !clienteId.isEmpty()) {
                            Prestamo prestamo = new Prestamo(
                                    prestamoId,
                                    clienteId,
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                                    cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("status")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("status")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("semanas")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("grupo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo")) : "0",
                                    cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) : "",
                                    cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : ""
                            );

                            prestamos.add(prestamo);
                            //Log.d("PrestamosWorker", "Prestamo añadido con ID: " + prestamoId);
                        } else {
                            Log.e("SQLiteClientes", "Registro con id o cliente_id nulo encontrado, omitiendo registro.");
                        }
                    } while (cursor.moveToNext());
                    cursor.close();
                }
                db.close();
                Log.d("PrestamosWorker", "Total de registros en LISTA prestamos DESPUES DE CONSULTA: " + prestamos);
                int totalRegistros = prestamos.size();
                Log.d("SQLiteClientes", "Total de registros en SQLite EN CONSULTA SQL: " + totalRegistros);

                // Actualizar la UI si hay registros y la tarea se completó
                if (totalRegistros > 0) {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        updateUIWithPrestamos(prestamos);
                    });
                } else {
                    Log.d("ClientesFragment", "No hay registros o la tarea no está completa.");
                }
                executor.shutdown();
            });
        }

        private void buscarGarantia(String cliente_id) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "buscarGarantia");
                data.put("cliente_id", cliente_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            Log.d("17", "loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                String status = response.get("status").toString();
                                if (status.equals("success")) {
                                    // Obtener el objeto data del response
                                    JSONArray dataArray = response.getJSONArray("data");
                                    if (dataArray.length() > 0) {
                                        JSONObject firstItem = dataArray.getJSONObject(0);
                                        idgarantia = firstItem.getInt("idgarantias_retiradas");
                                        Log.d("CACHE", "idgarantia: " + idgarantia);
                                    } else {
                                        Toast.makeText(context, "No se encontró la garantía.", Toast.LENGTH_SHORT).show();
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }
        private void registrarVenta(int prestamo_id, String fecha, int lugar, String importe, String tarjeton, String semana, String comentario, String idretiradas, int numeroSemanasElegidas, String pago_multa, String tipo_pago, String concepto, String folio) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            Log.d("CACHE", "prestamo_id prestamo_id: " + idgarantia);
            JSONObject data = new JSONObject();
            SimpleDateFormat inputFormat = new SimpleDateFormat("d/M/yyyy", Locale.getDefault());
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());


            try {
                // Convertir la fecha de entrada al formato correcto
                Date date = inputFormat.parse(fecha);
                String formattedDate = outputFormat.format(date);
                data.put("func", "pagar_garantia");
                data.put("id", idgarantia);
                data.put("fecha", formattedDate);
                data.put("lugar", lugar);
                data.put("importe", importe);
                data.put("tarjeton", tarjeton);
                data.put("semana", semana);
                data.put("comentario", comentario);
                data.put("idretiradas", idretiradas);
            } catch (JSONException e) {
                e.printStackTrace();
            } catch (java.text.ParseException e) {
                throw new RuntimeException(e);
            }
            Log.d("DATA", data.toString());
            Log.d("18", "loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                String data = response.get("status").toString();
                                Date date = inputFormat.parse(fecha);
                                if (data.equals("success")) {

                                    String formattedDate = outputFormat.format(date);
                                    int can = Integer.parseInt(importe) / numeroSemanasElegidas;
                                    actualizarPagoGarantia(String.valueOf(prestamo_id), semana, String.valueOf(can), comentario, pago_multa,tipo_pago,concepto,folio,formattedDate);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            } catch (java.text.ParseException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }

        private void actualizarPagoGarantia(String prestamo_id, String semana, String importe, String comentario, String pago_multa, String tipo_pago, String concepto, String folio, String formattedDate) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();

            try {
                data.put("func", "ActualizarSemanaGarantia");
                data.put("tarjeton", prestamo_id);
                data.put("semana", semana);
                data.put("importe", importe);
                data.put("comentario", comentario);
                data.put("pago_multa", pago_multa);
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
                data.put("concepto", concepto);
                data.put("folio", folio);
                data.put("fecha", formattedDate);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d("DATA", data.toString());
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                String data = response.get("status").toString();
                                if (data.equals("success")) {
                                    //Toast.makeText(context, "Pago con garantia registrado", Toast.LENGTH_SHORT).show();
                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }
        private void getGarantias(String cliente_id, TextView tvCantidadGarantias, CheckBox cbPagarConGarantias, EditText tvdescripcionGarantias, Button btnToggleVisibility, TextView tvIdGarantias) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            cantidadTotalGarantias=0;
            try {
                data.put("func", "getGarantiasRetiradas");
                data.put("cliente_id", cliente_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            Log.d("getGarantias", "getGarantias cliente_id: " + cliente_id);
            Log.d("19", "loadAllData: ");
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlClientes, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                Log.d("getGarantias", "Response: " + response.toString());
                                JSONArray dataArray = response.getJSONArray("data");
                                if (dataArray.length() > 0) {

                                    StringBuilder descGarantiasBuilder = new StringBuilder();
                                    StringBuilder idsGarantiasBuilder = new StringBuilder();

                                    for (int i = 0; i < dataArray.length(); i++) {
                                        JSONObject obj = dataArray.getJSONObject(i);
                                        Log.d("getGarantias", "Data: " + obj.toString());
                                        int cantidadGarantias = obj.getInt("cantidad_garantias");
                                        cantidadTotalGarantias += cantidadGarantias;

                                        String descGarantias = obj.getString("g_descripcion");
                                        if (descGarantiasBuilder.length() > 0) {
                                            descGarantiasBuilder.append(", ");
                                        }
                                        descGarantiasBuilder.append(descGarantias);

                                        String idsGarantias = obj.getString("idgarantias_retiradas");
                                        if (idsGarantiasBuilder.length() > 0) {
                                            idsGarantiasBuilder.append(", ");
                                        }
                                        idsGarantiasBuilder.append(idsGarantias);
                                    }

                                    tvdescripcionGarantias.setText(descGarantiasBuilder.toString());
                                    tvIdGarantias.setText(idsGarantiasBuilder.toString());
                                    String textoGarantias = "Garantías retiradas disponibles: " + cantidadTotalGarantias;
                                    tvCantidadGarantias.setText(textoGarantias);

                                    // Mostrar u ocultar el TextView y el CheckBox en función de la cantidad de garantías
                                    if (cantidadTotalGarantias > 0) {
                                        btnToggleVisibility.setVisibility(View.VISIBLE);
                                        tvCantidadGarantias.setVisibility(View.VISIBLE);
                                        cbPagarConGarantias.setVisibility(View.VISIBLE);
                                    } else {
                                        btnToggleVisibility.setVisibility(View.GONE);
                                        tvCantidadGarantias.setVisibility(View.GONE);
                                        cbPagarConGarantias.setVisibility(View.GONE);
                                    }
                                } else {
                                    Log.d("getGarantias", "No data found for cliente_id: " + cliente_id);
                                    // Ocultar el TextView y el CheckBox si no hay datos
                                    btnToggleVisibility.setVisibility(View.GONE);
                                    tvCantidadGarantias.setVisibility(View.GONE);
                                    cbPagarConGarantias.setVisibility(View.GONE);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e("getGarantias", "Error: " + error.toString());
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        }
        private void hacerComentario(Prestamo prestamo, String comentario) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "hacerComentario");
                data.put("prestamo_id", prestamo.getId());
                data.put("comentario", comentario);

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {

                            try {
                                String data = response.get("status").toString();

                                if (data.equals("success")) {
                                    Toast.makeText(context, "Se ha hecho el comentario", Toast.LENGTH_SHORT).show();
                                }

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, context);

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);

        }

        private void AdelantarpagarSemana(Prestamo prestamo, String semana, String status, String tipo_pago, String pagoSemanal) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            String pagoMultaLocal = "0.00";
            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagarSiguienteAdelantado");
                data.put("prestamo_id", prestamo_id);
                data.put("semana", semana);
                data.put("statusPago", status);
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.getString("status").equals("success")) {
                                    // Obtener el campo updated_at del servidor
                                    String updatedAt = response.getJSONObject("data").getString("updated_at");
                                    Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                    // Llamar al método de SQLite para actualizar el registro local
                                    actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, status, sesion.getString("id", "0"), "",pagoSemanal,pagoMultaLocal,"","on", "", updatedAt);
                                    getPagos(prestamo.getId());
                                    //Toast.makeText(context, "Pago realizado", Toast.LENGTH_SHORT).show();

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, context) == 1
                            || ErrorChecker.checker(error, context) == 4) {

                        //pagoController.nueva(pago);
                        actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, status, sesion.getString("id", "0"), "",pagoSemanal, pagoMultaLocal,"","off", "", "");
                        //Toast.makeText(context, "Sin conexión, Se guardo el Pago en local", Toast.LENGTH_SHORT).show();
                        pagosAdapter.pagosSeleccionados.clear();
                        getPagos(prestamo.getId());

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                    }

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    10000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);

        }

        private void pagarSemana(Prestamo prestamo, String semana, String status, String tipo_pago, String pagoSemanal) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            String pagoMultaLocal = "0.00";
            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagarSiguiente");
                data.put("prestamo_id", prestamo_id);
                data.put("semana", semana);
                data.put("statusPago", status);
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            /*
            Pago pago = new Pago("", prestamo.getId(), "", "",
                    "", "", "", "", "", "",
                    "", semana, "", sesion.getString("id", ""), "1", "","");
            */

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.getString("status").equals("success")) {
                                    // Obtener el campo updated_at del servidor
                                    String updatedAt = response.getJSONObject("data").getString("updated_at");
                                    Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                    // Llamar al método de SQLite para actualizar el registro local
                                    actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "1", sesion.getString("id", "0"), "",pagoSemanal,pagoMultaLocal,"","on", "", updatedAt);
                                    getPagos(prestamo.getId());
                                    //Toast.makeText(context, "Pago realizado", Toast.LENGTH_SHORT).show();

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, context) == 1
                            || ErrorChecker.checker(error, context) == 4) {

                        //pagoController.nueva(pago);
                        actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "1", sesion.getString("id", "0"), "",pagoSemanal, pagoMultaLocal,"","off", "", "");
                        //Toast.makeText(context, "Sin conexión, Se guardo el Pago en local", Toast.LENGTH_SHORT).show();
                        getPagos(prestamo.getId());

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                    }

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    10000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);

        }

        @SuppressLint("Range")
        private void actualizarPagoEnSQLite(Prestamo prestamo, int prestamo_id, String semana, String tipo_pago, String status, String empleado_id, String concepto, String pagoSemanal, String pagoMultaLocal, String tipo_p, String off, String folio, String updatedAt) {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getWritableDatabase();

            // Crear los valores a actualizar
            ContentValues valores = new ContentValues();
            valores.put("prestamo_id", prestamo_id);
            valores.put("semana", semana);
            valores.put("tipo_pago", tipo_pago);
            valores.put("status", status);
            valores.put("empleado_id", empleado_id);
            valores.put("concepto", concepto);
            valores.put("cantidad_multa", pagoMultaLocal);
            if(!folio.isEmpty())
            {
                valores.put("folio", folio);
            }
            else
            {
                valores.put("folio", "0");
            }
            // Obtener el timestamp actual y formatearlo
            long timestamp = System.currentTimeMillis();

            if(off.equals("off"))
            {
                valores.put("sinc", "1");
                Log.d("PrestamosFragment", "ENTRO EN MODO OFFLINE EL PAGO.......");
                // SUMAR 10 segundos (10,000 milisegundos)
                timestamp += 10000; // 10 segundos = 30,000 milisegundos
            }
            else
            {
                Log.d("PrestamosFragment", "ENTRO EN MODO CON CONEXION EL PAGO.......: ");
                timestamp -= 10000; // 10 segundos = 30,000 milisegundos
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));
            // Formatear la nueva hora

            valores.put("updated_at", formattedDate);
            if(!updatedAt.equals("") )
            {
                Log.d("PrestamosFragment", "ENTRO EN MODO CON CONEXION EL PAGO + regreso el tiempo del servidor.......: " + updatedAt);
                valores.put("updated_at", updatedAt);
            }

            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            String formattedDate2 = sdf2.format(new Date(timestamp));
            valores.put("fecha_pago_realizada", formattedDate2);

            // Obtener el valor actual de "cantidad_normal_pagada" como String desde la base de datos
            String cantidadNormalExistenteStr = "0.00";
            String queryNormal = "SELECT cantidad_normal_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
            Cursor cursorNormal = db.rawQuery(queryNormal, new String[]{String.valueOf(prestamo_id), semana});

            if (cursorNormal.moveToFirst()) {
                cantidadNormalExistenteStr = cursorNormal.getString(cursorNormal.getColumnIndex("cantidad_normal_pagada"));
            }
            cursorNormal.close();

            // Convertir y sumar el nuevo valor de "cantidad_normal_pagada"
            double cantidadNormalExistente = Utils.convertirDouble(cantidadNormalExistenteStr);
            double cantidadPagada = Utils.convertirDouble(pagoSemanal);
            double nuevaCantidadNormalPagada = cantidadNormalExistente + cantidadPagada;

            DecimalFormat decimalFormat = new DecimalFormat("#.00");
            String pagoNormalTotCantidad = decimalFormat.format(nuevaCantidadNormalPagada);
            valores.put("cantidad_normal_pagada", pagoNormalTotCantidad);
            valores.put("recuperado", pagoNormalTotCantidad);

            // Obtener el valor actual de "cantidad_total_pagada" como String y convertir a double
            String cantidadTotalExistenteStr = "0.00";
            String queryTotal = "SELECT cantidad_total_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
            Cursor cursorTotal = db.rawQuery(queryTotal, new String[]{String.valueOf(prestamo_id), semana});

            if (cursorTotal.moveToFirst()) {
                cantidadTotalExistenteStr = cursorTotal.getString(cursorTotal.getColumnIndex("cantidad_total_pagada"));
            }
            cursorTotal.close();

            // Convertir a double y sumar el nuevo total al valor existente
            double cantidadTotalExistente = Utils.convertirDouble(cantidadTotalExistenteStr);
            double pagoTotalNuevo = Utils.convertirDouble(pagoNormalTotCantidad) + Utils.convertirDouble(pagoMultaLocal);
            double nuevaCantidadTotalPagada = pagoTotalNuevo;

            String pagoTotCantidad = decimalFormat.format(nuevaCantidadTotalPagada);

            Log.d("SQLite", "No se pudo actualizar el pago en SQLite para cantidadTotalExistente: " + cantidadTotalExistente);
            Log.d("SQLite", "No se pudo actualizar el pago en SQLite para pagoTotalNuevo: " + pagoTotalNuevo);
            Log.d("SQLite", "No se pudo actualizar el pago en SQLite para pagoNormalTotCantidad: " + pagoNormalTotCantidad);
            Log.d("SQLite", "No se pudo actualizar el pago en SQLite para pagoMultaLocal: " + pagoMultaLocal);

            Log.d("SQLite", "No se pudo actualizar el pago en SQLite para nuevaCantidadTotalPagada: " + nuevaCantidadTotalPagada);

            valores.put("cantidad_total_pagada", pagoTotCantidad);

            // Calcular y actualizar "cantidad_pendiente" si el pago es menor a lo debido
            double pago_semana = Utils.convertirDouble(prestamo.getPago_semanal());
            double pendiente_final = pago_semana - nuevaCantidadNormalPagada;

            if (pendiente_final > 0) {
                String pagoPenCantidad = decimalFormat.format(pendiente_final);
                valores.put("cantidad_pendiente", pagoPenCantidad);
            } else {
                valores.put("cantidad_pendiente", "0.00");
            }
            ////////////CONDICION PARA OMITIR SEMANA 15 O 20 Y CAMBIAR ESTATUS DE PRESTAMO//////////////////
            int tiene_multas = Integer.parseInt(prestamo.getTiene_multas());
            int tiene_pendientes = Integer.parseInt(prestamo.getTiene_pendientes());
            int tiene_folios = Integer.parseInt(prestamo.getTiene_folios());

            if ("14".equals(semana) || "19".equals(semana) || "15".equals(semana) || "20".equals(semana)) {
                Log.d("DEBUG", "Semana coincide con 14 o 19");
                if (tiene_multas==0 && tiene_pendientes==0 && tiene_folios==0)
                {
                    String ultimaSemana = "14".equals(semana) ? "15" : "20";

                    // Crear un DecimalFormat para asegurar que el valor tenga 2 decimales
                    DecimalFormat decimalFormat4 = new DecimalFormat("#.00");

                    // Formatear cantidadPagada para que siempre tenga 2 decimales
                    String cantidadPagadaFormatted = decimalFormat4.format(cantidadPagada);

                    ContentValues valoresUltimaSemana = new ContentValues();
                    valoresUltimaSemana.put("prestamo_id", prestamo_id);
                    valoresUltimaSemana.put("semana", ultimaSemana);
                    valoresUltimaSemana.put("status", "2");
                    valoresUltimaSemana.put("empleado_id", empleado_id);
                    valoresUltimaSemana.put("concepto", "Semana omitida");
                    valoresUltimaSemana.put("cantidad_normal_pagada", cantidadPagadaFormatted);
                    valoresUltimaSemana.put("cantidad_total_pagada", cantidadPagadaFormatted);
                    valoresUltimaSemana.put("updated_at", formattedDate);
                    valoresUltimaSemana.put("fecha_pago_realizada", formattedDate2);

                    long insertResult = db.update("pagos", valoresUltimaSemana, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), ultimaSemana});

                    if (insertResult != -1) {
                        Log.d("SQLite", "Registro insertado en la última semana de pago con status 2: Semana " + ultimaSemana);

                        // Si la inserción fue exitosa, actualizar el status del préstamo en la tabla `prestamos` a 1
                        ContentValues valoresPrestamo = new ContentValues();
                        valoresPrestamo.put("status", "1");

                        int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                        if (updatePrestamoResult > 0) {
                            Log.d("SQLite", "Status del préstamo actualizado a 1 para prestamo_id: " + prestamo_id);
                        } else {
                            Log.d("SQLite", "Error al actualizar el status del préstamo para prestamo_id: " + prestamo_id);
                        }
                    } else {
                        Log.d("SQLite", "Error al insertar registro en la última semana de pago");
                    }
                }
                if (tiene_pendientes==0 || "15".equals(semana) || "20".equals(semana)) {
                    ContentValues valoresPrestamo = new ContentValues();
                    valoresPrestamo.put("status", "1");

                    int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                    if (updatePrestamoResult > 0) {
                        Log.d("SQLite", "Status del préstamo actualizado a 1 para prestamo_id: " + prestamo_id);
                    } else {
                        Log.d("SQLite", "Error al actualizar el status del préstamo para prestamo_id: " + prestamo_id);
                    }
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////

            // Actualizar el registro en la tabla `pagos`
            int filasActualizadas = db.update("pagos", valores, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), semana});

            if (filasActualizadas > 0) {
                Log.d("SQLite", "Pago actualizado correctamente en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana);
                //Toast.makeText(context, "Se actualizó el pago correctamente", Toast.LENGTH_LONG).show();
            } else {
                Log.d("SQLite", "No se pudo actualizar el pago en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana);
            }

            db.close(); // Cerrar la conexión a la base de datos
        }

        private void pagarConMultaSemana(Prestamo prestamo, String semana, String tipo_pago, String pagoSemanal, String pagoMultaLocal) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagarSiguienteConMulta");
                data.put("prestamo_id", prestamo.getId());
                data.put("semana", semana);
                data.put("statusPago", "0");
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            Log.d("DATA", data.toString());

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.getString("status").equals("success")) {
                                    // Obtener el campo updated_at del servidor
                                    String updatedAt = response.getJSONObject("data").getString("updated_at");
                                    Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                    actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "3", sesion.getString("id", "0"), "",pagoSemanal,pagoMultaLocal,tipo_pago, "on", "", updatedAt);
                                    getPagos(prestamo.getId());
                                    //Toast.makeText(context, "Pago realizado con multa", Toast.LENGTH_SHORT).show();

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    if (ErrorChecker.checker(error, context) == 1
                            || ErrorChecker.checker(error, context) == 4) {

                        //pagoController.nueva(pago);

                        actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "3", sesion.getString("id", "0"), "",pagoSemanal,pagoMultaLocal,tipo_pago, "off", "", "");
                        getPagos(prestamo.getId());
                        //Toast.makeText(context, "Sin conexión, Se guardo el Pago en local", Toast.LENGTH_SHORT).show();

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                    }

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    10000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);

        }

        private void noPagarSemana(Prestamo prestamo, String semana, String tipo_pago) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "noPagarSiguiente");
                data.put("prestamo_id", prestamo.getId());
                data.put("semana", semana);
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.getString("status").equals("success")) {
                                    // Obtener el campo updated_at del servidor
                                    String updatedAt = response.getJSONObject("data").getString("updated_at");
                                    Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                    // Llamar al método de SQLite para actualizar el registro local
                                    actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "-1", sesion.getString("id", "0"), "","0.00","0.00",tipo_pago, "on", "", updatedAt);
                                    getPagos(prestamo.getId());
                                    cargarPrestamosConsulta();
                                    //Toast.makeText(context, "Pago no recibido", Toast.LENGTH_SHORT).show();

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    if (ErrorChecker.checker(error, context) == 1
                            || ErrorChecker.checker(error, context) == 4) {

                        //pagoController.nueva(pago);
                        actualizarPagoEnSQLite(prestamo, prestamo_id, semana, tipo_pago, "-1", sesion.getString("id", "0"), "","0.00","0.00",tipo_pago, "off", "", "");
                        getPagos(prestamo.getId());
                        cargarPrestamosConsulta();
                        //Toast.makeText(context, "Sin conexión, Se guardo el Pago en local", Toast.LENGTH_SHORT).show();

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                    }

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    10000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));


            request.setShouldCache(false);
            requestQueue.add(request);

        }
        private void getPagos(String prestamoId) {
            if (pagosAdapter == null) {
                Log.e("getPagos", "Error: pagosAdapter is null." + prestamoId);
                return; // Salir del método si el adaptador es nulo
            }
            // Instancia del controlador de la base de datos
            DatabaseHelper pagoMigration = new DatabaseHelper(context);

            // Obtener los pagos desde SQLite
            List<Pago> pagosDesdeDb = pagoMigration.getPagosFromDatabase(prestamoId);

            // Limpiar el adaptador y la lista global de pagos
            pagosAdapter.clear();
            pagos.clear();

            // Agregar los pagos recuperados de la base de datos a la lista global
            pagos.addAll(pagosDesdeDb);

            // Actualizar el adaptador con la lista de pagos
            pagosAdapter.addAll(pagos);
            pagosAdapter.notifyItemRangeChanged(pagos.size(), 1);
            shimmer.startShimmer();
            shimmer.setVisibility(View.GONE);
            recyclerViewPagos.setVisibility(View.VISIBLE);
        }

        private void getPagosFolio(String prestamoId, Prestamo prestamo1) {
            pagos = new ArrayList<Pago>();
            pagosAdapter = new PagosAdapter(context, pagos, prestamo1);
            // Instancia del controlador de la base de datos
            DatabaseHelper pagoMigration = new DatabaseHelper(context);

            // Obtener los pagos desde SQLite
            List<Pago> pagosDesdeDb = pagoMigration.getPagosFromDatabase(prestamoId);

            // Limpiar el adaptador y la lista global de pagos
            pagosAdapter.clear();
            pagos.clear();

            // Agregar los pagos recuperados de la base de datos a la lista global
            pagos.addAll(pagosDesdeDb);

            // Actualizar el adaptador con la lista de pagos
            pagosAdapter.addAll(pagos);
            pagosAdapter.notifyItemRangeChanged(pagos.size(), 1);
        }


        /*
        private void getPagos(String prestamo_id) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagosPrestamo");
                data.put("prestamo_id", prestamo_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {

                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                pagosAdapter.clear();
                                pagos.clear();

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Pago pago = gson.fromJson(obj.toString(), Pago.class);
                                    pagos.add(pago);
                                }

                                pagosAdapter.addAll(pagos);
                                pagosAdapter.notifyItemRangeChanged(pagos.size(), 1);
                                shimmer.startShimmer();
                                shimmer.setVisibility(View.GONE);
                                recyclerViewPagos.setVisibility(View.VISIBLE);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }
        */

        private void getInfo(String prestamo_id, int position, TextView tvSemanasPendientes, TextView tvSemanasAtraso) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagosPrestamo");
                data.put("prestamo_id", prestamo_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Pago pago = gson.fromJson(obj.toString(), Pago.class);
                                    pagos2.add(pago);
                                }

                                double suma_pendiente = 0.0;

                                for (Pago pago : pagos2) {
                                    suma_pendiente += Utils.convertirDouble(pago.getCantidad_pendiente());
                                }
                                List<Pago> pagosConStatusNegativo = new ArrayList<>();

                                for (Pago pago : pagos2) {
                                    if (pago.getStatus().equals("-1") || !pago.getCantidad_pendiente().equals("0.00") ) {
                                        pagosConStatusNegativo.add(pago);
                                    }
                                }
                                showVerInfo(position, suma_pendiente,pagosConStatusNegativo, tvSemanasPendientes,tvSemanasAtraso);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }
        private void getPagos2(String prestamo_id, int position) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "pagosPrestamo");
                data.put("prestamo_id", prestamo_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Gson gson = new Gson();
                                    Pago pago = gson.fromJson(obj.toString(), Pago.class);
                                    pagos2.add(pago);
                                }

                                double suma_pendiente = 0.0;

                                for (Pago pago : pagos2) {
                                    suma_pendiente += Utils.convertirDouble(pago.getCantidad_pendiente());
                                }
                                List<Pago> pagosConStatusNegativo = new ArrayList<>();

                                for (Pago pago : pagos2) {
                                    if (pago.getStatus().equals("-1") || !pago.getCantidad_pendiente().equals("0.00") ) {
                                        pagosConStatusNegativo.add(pago);
                                    }
                                }
                                showTicketDialog(position, suma_pendiente,pagosConStatusNegativo);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }

        private void showTicketDialog(int position, double suma_pendiente, List<Pago> pagosConStatusNegativo) {
            List<String> semanas_atraso = new ArrayList<>();

            for (Pago pago : pagosConStatusNegativo) {
                semanas_atraso.add("SEM "+pago.getSemana());
            }

            int multas3 =0;
            double multaPorSemana = 50;
            double sum_recargos=0;
            double monto_tot =0;

            NumberFormat formatoMoneda = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado = formatoMoneda.format(suma_pendiente);
            String nombre = sesion.getString("nombre", "");
            String telefono = sesion.getString("telefono", "");
            String colocadora_ticket = "\n COLOCADORA: " + new String(prestamos.get(position).getNombre_colocadora().getBytes(), StandardCharsets.UTF_8);
            String titulo_ticket = "PRESTAMO GRUSEF S.A DE C.V";
            String ruta_ticket = "\n RUTA: " + prestamos.get(position).getNombre_ruta();
            String poblacion_ticket = "\n POBLACION: " + new String(prestamos.get(position).getNombre_poblacion().getBytes(), StandardCharsets.UTF_8);
            String nombre_ticket = "\n CLIENTE: " + new String(prestamos.get(position).getNombre_completo().getBytes(), StandardCharsets.UTF_8);
            String aval_ticket = "\n AVAL: " + new String(prestamos.get(position).getNombre_aval().getBytes(), StandardCharsets.UTF_8);
            String atraso_ticket = "\n MONTO PENDIENTE: " + montoFormateado;
            String pago_ticket = "\n SEMANAS DE ATRASO: " +semanas_atraso;

            multas3 = Integer.parseInt(prestamos.get(position).getTiene_pendientes());
            sum_recargos = multaPorSemana * multas3;

            String montoFormateado2 = formatoMoneda.format(sum_recargos);
            Log.d("DEBUG", "Antes de RECARGOS multas3: " + multas3);
            Log.d("DEBUG", "Antes de RECARGOS multaPorSemana: " + multaPorSemana);
            Log.d("DEBUG", "Antes de RECARGOS sum_recargos: " + sum_recargos);
            Log.d("DEBUG", "Antes de RECARGOS: " + montoFormateado2);
            monto_tot = sum_recargos + suma_pendiente;
            Log.d("DEBUG", "Antes de RECARGOS monto_tot: " + monto_tot);
            NumberFormat formatoMoneda3 = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado3 = formatoMoneda3.format(monto_tot);

            String recargos_ticket = "\n RECARGOS: " + montoFormateado2;
            String monto_tot_ticket = "\n PAGO REQUERIDO: " + montoFormateado3;
            Log.d("DEBUG", "Antes de clear PAGOS: " + monto_tot_ticket);

            String aviso = "\nESTIMADO CLIENTE\n\n" +
                    "ES DE SUMA IMPORTANCIA\n" +
                    "RECORDARLE QUE SU CREDITO\n"+
                    "PRESENTA SEMANAS PENDIENTES\n"+
                    "POR PAGAR LE SUGERIMOS PONERSE\n"+
                    "AL CORRIENTE Y ASI EVITAR\n"+
                    "PROBLEMAS LEGALES EN SU CONTRA.\n\n" +
                    "POR FAVOR NO HAGA CASO OMISO\n" +
                    "O NOS VEREMOS EN LA NECESIDAD DE\n" +
                    "SOLICITAR LA LIQUIDACION\n DE SU CUENTA\n" +
                    "GRACIAS.\n\n" +
                    "LA SOLUCION ESTA EN SUS MANOS\n"+
                    "NO LAS DEJE EN LAS NUESTRAS!\n\n" +
                    "PARA COMUNICARSE CON NOSOTROS\n\n";
            String avisoPDF = "\nESTIMADO CLIENTE:\n" +
                    "ES DE SUMA IMPORTANCIA " +
                    "RECORDARLE QUE SU CREDITO "+
                    "PRESENTA SEMANAS PENDIENTES "+
                    "POR PAGAR, LE SUGERIMOS PONERSE "+
                    "AL CORRIENTE Y ASI EVITAR "+
                    "PROBLEMAS LEGALES EN SU CONTRA.\n\n" +
                    "POR FAVOR NO HAGA CASO OMISO " +
                    "O NOS VEREMOS EN LA NECESIDAD DE " +
                    "SOLICITAR LA LIQUIDACION DE SU CUENTA\n" +
                    "GRACIAS.\n\n" +
                    "LA SOLUCION ESTA EN SUS MANOS "+
                    "NO LAS DEJE EN LAS NUESTRAS!\n\n" +
                    "PARA COMUNICARSE CON NOSOTROS\n\n";
            String empleado_ticket = "GESTOR: "+nombre+"\nCEL: "+telefono;
            String aviso2 = "OFICINAS: LIC. RODRIGO GONZALEZ\n" +
                    "CEL: 8714756305 ";

            TextView tituloTextView = new TextView(context);
            tituloTextView.setText(titulo_ticket);
            tituloTextView.setTypeface(null, Typeface.BOLD);

            TextView rutaTextView = new TextView(context);
            rutaTextView.setText(ruta_ticket);

            TextView poblacionTextView = new TextView(context);
            poblacionTextView.setText(poblacion_ticket);

            TextView colocadoraTextView = new TextView(context);
            colocadoraTextView.setText(colocadora_ticket);

            TextView nombreTextView = new TextView(context);
            nombreTextView.setText(nombre_ticket);

            TextView avalTextView = new TextView(context);
            avalTextView.setText(aval_ticket);

            TextView atrasoTextView = new TextView(context);
            atrasoTextView.setText(atraso_ticket);

            TextView pagoTextView = new TextView(context);
            pagoTextView.setText(pago_ticket);

            TextView avisoTextView = new TextView(context);
            avisoTextView.setText(recargos_ticket);

            TextView totTextView = new TextView(context);
            totTextView.setText(monto_tot_ticket);
            totTextView.setTypeface(null, Typeface.BOLD);

            LinearLayout linearLayout = new LinearLayout(context);
            linearLayout.setOrientation(LinearLayout.VERTICAL);
            linearLayout.addView(tituloTextView);
            linearLayout.addView(rutaTextView);
            linearLayout.addView(poblacionTextView);
            linearLayout.addView(colocadoraTextView);
            linearLayout.addView(nombreTextView);
            linearLayout.addView(atrasoTextView);
            linearLayout.addView(pagoTextView);
            linearLayout.addView(avisoTextView);
            linearLayout.addView(totTextView);

            AlertDialog.Builder builder5 = new AlertDialog.Builder(context);
            builder5.setView(linearLayout)
                    .setPositiveButton("Imprimir", new DialogInterface.OnClickListener() {
                        @RequiresApi(api = Build.VERSION_CODES.O)
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();

                            BluetoothUtils.context = context;
                            BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);
                            try {
                                BluetoothUtils.printText(titulo_ticket,ruta_ticket,poblacion_ticket,nombre_ticket,atraso_ticket,pago_ticket,aviso,aviso2,empleado_ticket,colocadora_ticket,aval_ticket,recargos_ticket,monto_tot_ticket);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    })
                    .setNeutralButton("Compartir", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            fragment.compartirTexto(titulo_ticket,ruta_ticket,poblacion_ticket,nombre_ticket,atraso_ticket,pago_ticket,avisoPDF,aviso2,empleado_ticket,colocadora_ticket,aval_ticket,recargos_ticket,monto_tot_ticket);
                        }
                    })
                    .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                        }
                    });

            AlertDialog previewDialog = builder5.create();
            previewDialog.show();
        }
        private void showVerInfo(int position, double suma_pendiente, List<Pago> pagosConStatusNegativo, TextView tvSemanasPendientes, TextView tvSemanasAtraso) {
            List<String> semanas_atraso = new ArrayList<>();

            for (Pago pago : pagosConStatusNegativo) {
                semanas_atraso.add("SEM "+pago.getSemana());
            }

            NumberFormat formatoMoneda = NumberFormat.getCurrencyInstance(new Locale("es", "MX"));
            String montoFormateado = formatoMoneda.format(suma_pendiente);
            String ruta_ticket = "\n RUTA: " + prestamos.get(position).getNombre_ruta();
            String atraso_ticket = montoFormateado;
            String pago_ticket = "" +semanas_atraso;

            int multas3 = Integer.parseInt(prestamos.get(position).getTiene_pendientes());
            double multaPorSemana = 50.0;
            double sum_recargos = multaPorSemana * multas3;

            String montoFormateado2 = formatoMoneda.format(sum_recargos);

            double monto_tot = sum_recargos + suma_pendiente;
            NumberFormat formatoMoneda3 = NumberFormat.getCurrencyInstance(Locale.getDefault());
            String montoFormateado3 = formatoMoneda3.format(monto_tot);

            String recargos_ticket = "\n RECARGOS: " + montoFormateado2;
            String monto_tot_ticket = "\n PAGO REQUERIDO: " + montoFormateado3;

            tvSemanasPendientes.setText(Html.fromHtml("<b>SEMANAS DE ATRASO:</b><br>" + pago_ticket));
            tvSemanasAtraso.setText(Html.fromHtml("<b>MONTO PENDIENTE:</b><br>" + atraso_ticket));
        }
        private void getFecha(String prestamo_id, String semana) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data2 = new JSONObject();
            Log.d("DEBUG", "Antes de clear PAGOS: " + prestamo_id +" / "+ semana);
            try {
                data2.put("func", "pagosPrestamo_fecha");
                data2.put("prestamo_id", prestamo_id);
                data2.put("semana", semana);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            JsonRequest<JSONObject> request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data2,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.d("DEBUG", "Respuesta JSON: " + response.toString());

                            try {
                                if (response.has("data")) {
                                    JSONArray dataArray = response.getJSONArray("data");
                                    if (dataArray.length() > 0) { // Verifica si hay elementos en el arreglo
                                        JSONObject firstDataObject = dataArray.getJSONObject(0); // Obtén el primer objeto del arreglo
                                        if (firstDataObject.has("fecha_pago")) {
                                            String fecha = firstDataObject.getString("fecha_pago");
                                            Log.d("DEBUG", "Listas con datos: " + pathsGarantiasRetiradas+ "/" + archivosGeneral);
                                            subirGarantiasRetiradas(fecha, prestamo_id, pathsGarantiasRetiradas, (ArrayList<MultipartBody.Part>) archivosGeneral, "");
                                            pathsGarantiasRetiradas.clear();
                                            archivosGeneral.clear();
                                            Log.d("DEBUG", "Listas con vacias despues del insert: " + pathsGarantiasRetiradas+ "/" + archivosGeneral);
                                        } else {
                                            Log.d("DEBUG", "No se pudo obtener la fecha de pago en el primer objeto");
                                        }
                                    } else {
                                        Log.d("DEBUG", "El arreglo 'data' está vacío");
                                    }
                                } else {
                                    Log.d("DEBUG", "Respuesta JSON no contiene 'data'");
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                                Log.d("DEBUG", "Error al analizar la respuesta JSON");
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.d("ERROR", "Error de red al obtener la fecha de pago", error);
                    if (ErrorChecker.checker(error, context) == 1 || ErrorChecker.checker(error, context) == 4) {
                        /*
                        new MaterialAlertDialogBuilder(context)
                                .setTitle("Error")
                                .setMessage("Se produjo un error al obtener la fecha de pago.")
                                .setPositiveButton("OK", null)
                                .show();
                                */
                    }
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    DefaultRetryPolicy.DEFAULT_TIMEOUT_MS,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);
        }

        private void pagar(Prestamo prestamo, String prestamo_id2, String pago_recibido, String pago_multa,
                           String concepto, String fecha_pago, String folio, String semana, String tipo_pago, Prestamo prestamo1) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            String status_folio = "";
            if(pago_multa.equals("0.00") && !pago_recibido.equals("0.00")){
                status_folio = "1";
            }
            if(!pago_multa.equals("0.00") && !pago_recibido.equals("0.00")){
                status_folio = "3";
            }

            try {
                data.put("func", "pagarSemana");
                data.put("prestamo_id", prestamo_id2);
                data.put("semana", semana);
                data.put("folio", folio);
                data.put("pago_recibido", pago_recibido);
                data.put("concepto", concepto);
                data.put("pago_multa", pago_multa);
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            String finalStatus_folio = status_folio;

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (response.getString("status").equals("success")) {
                                    // Obtener el campo updated_at del servidor
                                    String updatedAt = response.getJSONObject("data").getString("updated_at");
                                    Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                    // Llamar al método de SQLite para actualizar el registro local
                                    actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo_id2), semana, tipo_pago, finalStatus_folio,
                                            sesion.getString("id", "0"), concepto, pago_recibido, pago_multa, tipo_pago, "on", folio, updatedAt);

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                            //Toast.makeText(context, "Pago realizado", Toast.LENGTH_SHORT).show();
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {
                    if (ErrorChecker.checker(error, context) == 1
                            || ErrorChecker.checker(error, context) == 4) {

                        actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo_id2), semana, tipo_pago, finalStatus_folio, sesion.getString("id", "0"), concepto,pago_recibido,pago_multa,tipo_pago, "off", folio, "");
                        //getPagosFolio(prestamo.getId(), prestamo1);
                        cargarPrestamosConsulta();
                        //Toast.makeText(context, "Sin conexión, Se guardo el Pago en local", Toast.LENGTH_SHORT).show();

                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión, se guardaron los datos en local."); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(context);
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> confirmationDialog.dismiss(), 3000);
                    }
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    10000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            request.setShouldCache(false);
            requestQueue.add(request);

        }

        private void siguienteFolio(TextInputLayout tlFolio) {

            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();

            semanasPagadasList = new ArrayList<>();

            try {
                data.put("func", "siguienteFolio");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONObject obj = response.getJSONObject("data");
                                tlFolio.getEditText().setText(obj.get("folio_consecutivo").toString());

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }

        private void cargarSemanas(String prestamo_id) {
            semanasAdelantadasList = new ArrayList<>();
            semanasPagadasConMultaList = new ArrayList<>();
            semanasNoPagadasList = new ArrayList<>();
            semanasPagadasList = new ArrayList<>();

            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase(); // Abre la base de datos en modo lectura
            Cursor cursor = null;
            Log.d("DEBUG", "DATO DE PRESTAMO EN cargarSemanas prestamo_id....................: " + prestamo_id);

            try {
                // Consulta unificada para obtener todas las semanas
                String query = "SELECT * FROM pagos WHERE prestamo_id = ? AND (status = '4' OR status = '3' OR status = '-1' OR (status = '1' AND cantidad_pendiente = '0.00'))";
                cursor = db.rawQuery(query, new String[]{prestamo_id});

                if (cursor != null && cursor.moveToFirst()) {
                    Log.d("DEBUG", "El cursor tiene registros, empezando a iterar.");
                    do {
                        Semana semana = new Semana();
                        // Asignar cada columna al atributo correspondiente
                        semana.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                        semana.setPrestamo_id(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")));
                        semana.setCantidad_esperada_pago(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_esperada_pago")));
                        semana.setCantidad_normal_pagada(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_normal_pagada")));
                        semana.setCantidad_multa(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_multa")));
                        semana.setCantidad_pendiente(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pendiente")));
                        semana.setCantidad_total_pagada(cursor.getString(cursor.getColumnIndexOrThrow("cantidad_total_pagada")));
                        semana.setConcepto(cursor.getString(cursor.getColumnIndexOrThrow("concepto")));
                        semana.setFecha_pago(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")));
                        semana.setFecha_pago_realizada(cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")));
                        semana.setFolio(cursor.getString(cursor.getColumnIndexOrThrow("folio")));
                        semana.setSemana(cursor.getString(cursor.getColumnIndexOrThrow("semana")));
                        semana.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                        semana.setStatus(cursor.getString(cursor.getColumnIndexOrThrow("status")));
                        semana.setUpdated_at(cursor.getString(cursor.getColumnIndexOrThrow("updated_at")));
                        semana.setTipo_pago(cursor.getString(cursor.getColumnIndexOrThrow("tipo_pago")));

                        // Clasificar según el estado
                        if ("4".equals(semana.getStatus())) {
                            semanasAdelantadasList.add(semana);
                            Log.d("DEBUG", "Semana adelantada agregada: " + semana.getSemana());
                        } else if ("3".equals(semana.getStatus())) {
                            semanasPagadasConMultaList.add(semana);
                            Log.d("DEBUG", "Semana con multa agregada: " + semana.getSemana());
                        } else if ("-1".equals(semana.getStatus())) {
                            semanasNoPagadasList.add(semana);
                            Log.d("DEBUG", "Semana no pagada agregada: " + semana.getSemana());
                        } else if ("1".equals(semana.getStatus()) && "0.00".equals(semana.getCantidad_pendiente())) {
                            semanasPagadasList.add(semana);
                            Log.d("DEBUG", "Semana pagada agregada: " + semana.getSemana());
                        }
                    } while (cursor.moveToNext());

                    // Ejecutar colorearSemanas en el hilo principal para cada lista
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        new Handler(Looper.getMainLooper()).post(() -> {
                            // Colorear las semanas adelantadas
                            colorearSemanas(semanasAdelantadasList,
                                    context.getResources().getColor(R.color.secondary),
                                    context.getResources().getColor(R.color.white), false);

                            // Colorear las semanas con multa
                            colorearSemanas(semanasPagadasConMultaList,
                                    context.getResources().getColor(R.color.warning_custom),
                                    context.getResources().getColor(R.color.black), false);

                            // Colorear las semanas no pagadas
                            colorearSemanas(semanasNoPagadasList,
                                    context.getResources().getColor(R.color.danger_custom),
                                    context.getResources().getColor(R.color.white), true);

                            // Colorear las semanas pagadas
                            colorearSemanas(semanasPagadasList,
                                    context.getResources().getColor(R.color.success_custom),
                                    context.getResources().getColor(R.color.white), false);
                        });
                    }
                } else {
                    Log.d("DEBUG", "El cursor está vacío, no se encontraron semanas.");
                }
            } catch (Exception e) {
                Log.d("DEBUG", "Error al obtener las semanas: " + e);
                e.printStackTrace();
                Toast.makeText(context, "Error al obtener las semanas", Toast.LENGTH_SHORT).show();
            } finally {
                if (cursor != null) {
                    cursor.close(); // Cierra el cursor para liberar recursos
                }
                db.close(); // Cierra la base de datos
            }
        }



        private void semanasPendientes(String prestamo_id) {
            VolleyS vs = VolleyS.getInstance(context);
            RequestQueue requestQueue = vs.getRequestQueue();
            JSONObject data = new JSONObject();
            semanasPendientesList = new ArrayList<>();
            try {
                data.put("func", "semanasPendientes");
                data.put("prestamo_id", prestamo_id);
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                    new Response.Listener<JSONObject>() {
                        @RequiresApi(api = Build.VERSION_CODES.N)
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                JSONArray data = (JSONArray) response.get("data");
                                for (int i = 0; i < data.length(); i++) {
                                    Gson gson = new Gson();
                                    JSONObject obj = data.getJSONObject(i);
                                    Semana semana = gson.fromJson(obj.toString(), Semana.class);
                                    semanasPendientesList.add(semana);
                                }
                                colorearSemanas(semanasPendientesList, context.getResources().getColor(R.color.success_custom), context.getResources().getColor(R.color.white), true);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    ErrorChecker.checker(error, context);

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
            request.setShouldCache(false);
            requestQueue.add(request);
        }

        @RequiresApi(api = Build.VERSION_CODES.N)
        private void colorearSemanas(ArrayList<Semana> semanasList, int color, int textColor, boolean enable) {
            for (Semana sem : semanasList) {
                if (semanasGeneradas.stream().anyMatch(o -> sem.getSemana().equals(o.getSemana()))) {

                    Semana semanaEncontrada = semanasGeneradas.stream().
                            filter(s -> s.getSemana().equals(sem.getSemana())).
                            findAny().orElse(null);

                    semanaEncontrada.btnSemana.setBackgroundColor(color);
                    semanaEncontrada.btnSemana.setTextColor(textColor);
                    semanaEncontrada.setCantidad_pendiente(sem.getCantidad_pendiente());
                    semanaEncontrada.btnSemana.setEnabled(enable);

                    if (!sem.getCantidad_pendiente().equals("0.00")) {
                        semanaEncontrada.btnSemana.setEnabled(true);
                        semanaEncontrada.btnSemana.setText(semanaEncontrada.btnSemana.getText() + "\n ($" + sem.getCantidad_pendiente() + ")");
                        semanaEncontrada.btnSemana.setBackgroundColor(context.getResources().getColor(R.color.danger_custom));
                        semanaEncontrada.btnSemana.setTextColor(context.getResources().getColor(R.color.white));
                    } else {
                        //Log.d("DEBUG", "El botón btnSemana es null para la semana " + semanaEncontrada.getSemana());
                        //Log.d("DEBUG", "La cantidad pendiente es '0.00' para la semana: " + sem.getSemana());
                        //Log.d("DEBUG", "Invocando colorearSemanas con " + semanasList + " semanas.");
                        semanaEncontrada.btnSemana.setText(semanaEncontrada.btnSemana.getText());
                    }
                }
            }
        }

        public List<Button> getAllButtons(ViewGroup layout) {
            List<Button> btn = new ArrayList<>();
            for (int i = 0; i < layout.getChildCount(); i++) {
                View v = layout.getChildAt(i);
                if (v instanceof Button) {
                    btn.add((Button) v);
                }
            }
            return btn;
        }

    }
    public List<Button> getAllButtons(ViewGroup layout) {
        List<Button> btn = new ArrayList<>();
        for (int i = 0; i < layout.getChildCount(); i++) {
            View v = layout.getChildAt(i);
            if (v instanceof Button) {
                btn.add((Button) v);
            }
        }
        return btn;
    }
    public void subirGarantiasRetiradas(String fecha_pago2, String prestamo, ArrayList<String> pathsGarantiasRetiradas, ArrayList<MultipartBody.Part> archivosGeneral, String tldescripcion) {
        HashSet<String> setPaths = new HashSet<>(pathsGarantiasRetiradas);
        pathsGarantiasRetiradas.clear();
        pathsGarantiasRetiradas.addAll(setPaths);

        HashSet<MultipartBody.Part> setArchivos = new HashSet<>(archivosGeneral);
        archivosGeneral.clear();
        archivosGeneral.addAll(setArchivos);

        ProgressDialog dialog = new ProgressDialog(context, R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Guardando, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        Retrofit retrofit = new Retrofit.Builder()
                .baseUrl(API.url)
                .addConverterFactory(GsonConverterFactory.create())
                .build();
        Log.d("DEBUG", "La lista pathsGarantiasRetiradas FORM antes de OK : " +archivosGeneral+"/"+pathsGarantiasRetiradas);
        if (pathsGarantiasRetiradas == null || pathsGarantiasRetiradas.isEmpty()) {
            Log.d("DEBUG", "La lista pathsGarantiasRetiradas es null");
            dialog.cancel();
        } else {
            if(pathsGarantiasRetiradas.size() > 0)
            {

                Log.d("DEBUG", "La lista pathsGarantiasRetiradas Tamaño: " + pathsGarantiasRetiradas.size());
                RetrofitInterface retrofitInterface = retrofit.create(RetrofitInterface.class);

                RequestBody func = RequestBody.create(MediaType.parse("multipart/form-data"), "subirFotosGarantiasRetiradas");

                RequestBody cliente_id = RequestBody.create(MediaType.parse("multipart/form-data"), prestamo ) ;
                RequestBody empleado_id = RequestBody.create(MediaType.parse("multipart/form-data"), sesion.getString("id", "0"));
                RequestBody garantias_retiradas_cliente = RequestBody.create(MediaType.parse("multipart/form-data"), pathsGarantiasRetiradas.size() + "");
                RequestBody fecha_pago = RequestBody.create(MediaType.parse("multipart/form-data"), fecha_pago2);
                RequestBody descripcion = RequestBody.create(MediaType.parse("multipart/form-data"), tldescripcion);
                Log.d("DEBUG", "La lista pathsGarantiasRetiradas FORM OK: " + prestamo + "/" + sesion.getString("id", "0") + "/" + pathsGarantiasRetiradas + "/" + fecha_pago2);

                Call<ResponseMe> call = retrofitInterface.subirFotosGarantiasRetiradas(archivosGeneral, func,
                        cliente_id,
                        garantias_retiradas_cliente,
                        fecha_pago,
                        empleado_id,
                        descripcion);
                call.enqueue(new Callback<ResponseMe>() {
                    public void onResponse(Call<ResponseMe> call, retrofit2.Response<ResponseMe> response) {

                        dialog.cancel();
                        if (response.isSuccessful()) {

                            Log.d("response", response.body().getMessage());

                            Toast.makeText(context, "Se han subido las imágenes de las garantías", Toast.LENGTH_LONG).show();
                            pathsGarantiasRetiradas.clear();
                            archivosGeneral.clear();
                            dialog.cancel();
                        } else {
                            try {

                                JSONObject jObjError = new JSONObject(response.errorBody().string());

                                new MaterialAlertDialogBuilder(context)
                                        .setTitle("Aviso")
                                        .setMessage(jObjError.getString("message"))
                                        .setPositiveButton("Ok", (dialogInterface, i) -> {
                                        })
                                        .show();

                            } catch (Exception e) {
                                Toast.makeText(context, e.getMessage(), Toast.LENGTH_LONG).show();
                            }
                        }
                    }

                    @Override
                    public void onFailure(Call<ResponseMe> call, Throwable t) {
                        dialog.cancel();
                        Log.d("TAG", "onFailure: " + t.getLocalizedMessage());
                    }
                });
            }
        }
    }
}

